package com.icetech.cloudcenter.api.redpack;

import com.icetech.common.domain.response.ObjectResponse;

/**
 * 红包操作
 * @author fangct
 */
public interface RedpackOperService {
    /**
     * 查询余额
     * @param parkCode
     * @return 分
     */
    ObjectResponse<Integer> queryBalance(String parkCode);

    /**
     * 扣除红包金额
     * @param parkCode
     * @param amount
     * @return
     */
    ObjectResponse deduct(String parkCode, Integer amount);

    /**
     * 退回红包
     * @param parkCode
     * @param amount
     * @return
     */
    ObjectResponse refund(String parkCode, Integer amount);

}
