package com.icetech.cloudcenter.api.park;

import com.icetech.basics.domain.entity.AreaDistrict;
import com.icetech.basics.domain.entity.AreaProvince;
import com.icetech.basics.domain.entity.AreaCity;
import com.icetech.cloudcenter.domain.park.ParkConfigInfo;
import com.icetech.cloudcenter.domain.park.ParkConfigInfoFind;
import com.icetech.cloudcenter.domain.response.ParkConfigDto;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;
import java.util.Map;

/**
 * 车场服务接口
 * @author fangct
 */
public interface ParkConfigService {
    /**
     * Load查询
     */
    @Deprecated
    ObjectResponse<ParkConfigDto> selectByParkCode(String parkCode);

    /**
     * 车场id查询
     */
    @Deprecated
    ObjectResponse<ParkConfigDto> selectByParkId(Long parkId);
    /**
     * 新建车场配置
     * @param parkConfigInfo
     * @return
     */
    ObjectResponse saveParkConfigInfo(ParkConfigInfo parkConfigInfo);

    /**
     * 更新车场配置
     * @param parkConfigInfo
     * @return
     */
    ObjectResponse<Void> updateParkConfigInfo(ParkConfigInfo parkConfigInfo);
    ObjectResponse<ParkConfigInfoFind>  selectParkConfigInfoByParkCode(String parkCode);
    ObjectResponse<List<AreaCity>> selectAllAreaCityData(Integer id);
    ObjectResponse<List<AreaDistrict>> selectAllAreaDistrictData(Integer id);
    ObjectResponse<List<AreaProvince>> selectAllAreaProvinceData(Integer id);

    ObjectResponse<Boolean> batchUpdateParkConfigPayWayByParkId(Map<Long, String> payWayMap);
}
