package com.icetech.cloudcenter.api.park;

import com.icetech.basics.domain.entity.device.FleetModeLog;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 车队模式操作表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-12-11
 */
public interface FleetModeLogService extends IBaseService<FleetModeLog> {

    /**
     * Description: 根据ID查询 车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param id 对象id
     * @return FleetModeLog
     */
    FleetModeLog getFleetModeLogById(Long id);

    /**
     * Description: 新增  车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addFleetModeLog(FleetModeLog entity);

    /**
     * Description: 修改 车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyFleetModeLog(FleetModeLog entity);

    /**
     * Description: 删除  车队模式操作表对象信息 <br>
     * Version1.0 2024-12-11 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeFleetModeLogById(Long id);
}
