package com.icetech.cloudcenter.api.order;

import java.util.List;

import com.icetech.order.domain.entity.OrderTrack;

public interface OrderTrackService {
    /**
     * 根据车场ID及订单号查询订单轨迹列表并按出入场时间正序排序
     * @param parkId 车场ID
     * @param orderNum 订单号
     * @return 按出入场时间正序排序的订单轨迹列表
     */
    List<OrderTrack> getTracksByOrder(Long parkId, String orderNum);
}
