package com.icetech.cloudcenter.api.order;

import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.request.OrderAddRequest;
import com.icetech.cloudcenter.domain.response.OrderCountDto;
import com.icetech.order.domain.dto.OrderInfoDto;
import com.icetech.park.domain.entity.MadePlate;
import com.icetech.order.domain.entity.OrderAfterPay;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.cloudcenter.domain.order.ModifyCarDto;
import com.icetech.cloudcenter.domain.order.OrderVO;
import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.request.OrderQueryRequest;
import com.icetech.cloudcenter.domain.request.PlateModifyCarRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.SearchCarRequest;
import com.icetech.cloudcenter.domain.response.EnterCarDto;
import com.icetech.cloudcenter.domain.response.ExitCarDto;
import com.icetech.cloudcenter.domain.response.InParkNumInfoResponse;
import com.icetech.cloudcenter.domain.response.OrderDto;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.SearchCarResponse;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.request.OrderStatusParam;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Description : 订单服务接口
 * @author fangct
 */
public interface OrderService {
    /**
     * 保存先离场后付费信息
     * @param parkId
     * @param orderInfo
     * @param type 类型:1杭州城市大脑; 2:无锡先离场后付费;3无锡区先离场后付费;4苏州吴中区先离场后付费;5苏州吴江区先离场后付费;6苏州姑苏区先离场后付费;7无锡惠山区
     * @return
     */
    ObjectResponse<String> addOrderAfterPay(Long parkId, OrderInfo orderInfo, Integer type);
    /**
     * 查询先离场后付费的订单
     * @param status 状态
     * @param type 1:杭州城市大脑; 2:无锡先离场后付费
     * @return
     */
    ObjectResponse<List<OrderAfterPay>> selectAfterPayList(Integer status, Integer type);

    /**
     * 查询先离场后付费的订单
     * @param status 状态1 已完成0未完成 2异常
     * @param type 1:杭州城市大脑; 2:无锡先离场后付费
     * @param time 根据修改时间查询
     * @return
     */
    ObjectResponse<List<OrderAfterPay>> selectAfterPayLists(Integer status, Integer type, String time);

    /**
     * 更新先离场后付费记录
     * @param orderAfterPay
     * @return
     */
    ObjectResponse updateAfterPay(OrderAfterPay orderAfterPay);
    /**
     * 车牌置信度低的订单列表
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return
     */
    ObjectResponse<List<EnterCarDto>> getAlarmPlateList(String parkCode, Date startTime, Date endTime);
    /**
     * 离场记录条数
     * @return
     */
    ObjectResponse<Map<String, Object>> countExitCarList(OrderQueryRequest orderQueryRequest);

    /**
     * 车辆在场记录总条数
     * @return
     */
    ObjectResponse<Map<String, Object>> countEnterCarList(OrderQueryRequest orderQueryRequest);

    /**
     * 取消订单
     * @param orderNum
     * @param username
     * @return 订单修改记录ID
     */
    ObjectResponse<Long> delOrder(String orderNum, String username);

    /**
     * 验证车牌是否未在场车辆
     * @param plateNumber
     * @param carType
     * @return
     */
    ObjectResponse checkCar(String orderNum,String plateNumber,Integer carType);
    /**
     * 修改车牌信息
     * @param orderNum
     * @param plateNumber
     * @param carType
     * @return
     */
    ObjectResponse modifyCar(String orderNum,String plateNumber,Integer carType);

    /**
     *
     * @param dto
     * @return 订单修改记录ID
     */
    ObjectResponse<Long> modifyCar(ModifyCarDto dto);

    /**
     * 车牌修改
     * @param plateModifyCarRequest           dto参数
     * @return
     */
    ObjectResponse<Long> modifyCar(PlateModifyCarRequest plateModifyCarRequest);
    /**
     * 查询车牌号指定时间内订单
     * @param parkId 必填
     * @param startTime
     * @param endTime
     * @param plateNum
     * @return
     */
    ObjectResponse<List<OrderInfo>> selectListByParam(Long parkId, Long startTime, Long endTime, String plateNum);
    /**
     * 根据订单号查询
     * @param orderNum
     * @return
     */
    ObjectResponse<OrderInfo> findByOrderNum(String orderNum);

    /**
     * 查询包含历史表的订单
     * @param orderNum 订单号
     * @return 订单信息
     */
    ObjectResponse<OrderInfo> findWithHistoryByOrderNum(String orderNum);
    List<OrderInfo> findWithHistoryByOrderNums(List<String> orderNums, List<String> tables);

    /**
     * 根据车牌号查询场内订单
     * @param plateNum 必填
     * @param parkCode 可能为空
     * @return
     */
    ObjectResponse<OrderInfo> findInPark(String plateNum, String parkCode);

    ObjectResponse<OrderInfo> findInParkId(String plateNum, Long parkId);

    ObjectResponse<OrderSonInfo> findOrderSon(String orderNum, Long regionId);

    /**
     * 查询车辆信息
     * @param pageQuery
     * @return
     */
    ObjectResponse<List<SearchCarResponse>> searchCarInfo(PageQuery<SearchCarRequest> pageQuery);

    /**
     * 根据订单信息查询
     * @param orderInfo
     * @return
     */
    ObjectResponse<OrderInfo> findByOrderInfo(OrderInfo orderInfo);

    /**
     * 车辆在场记录表
     * @return
     */
    ObjectResponse<List<EnterCarDto>> getEnterCarList(OrderQueryRequest orderQueryRequest);
/**
     * 车辆入场记录详情
     * @param parkCode 车场编号
     * @param recordId 入场记录id
     * @return
     */
    ObjectResponse<EnterCarDto> getEnterCarDetail(String parkCode, Integer recordId);

    /**
     * 车辆离场记录表
     * @return
     */
    ObjectResponse<List<ExitCarDto>> getExitCarList(OrderQueryRequest orderQueryRequest);
    /**
     * 停车时长统计
     * @param parkIds
     * @param day
     * @param day
     * @return
     */
    ObjectResponse<List<ExitCarDto>> countParkingTime(String parkIds,Integer day,String pointMonth);
    /**
     * 车辆离场记录详情
     * @param parkCode 车场编号
     * @param recordId 离场记录id
     * @return
     */
    ObjectResponse<ExitCarDto> getExitCarDetail(String parkCode, Integer recordId);

    /**
     * 保存订单信息
     * @param orderInfo
     * @return
     */
    ObjectResponse addOrderInfo(OrderInfo orderInfo);
    /**
     * 修改订单信息
     * @param orderInfo
     * @return
     */
    ObjectResponse updateOrderInfo(OrderInfo orderInfo);

    ObjectResponse<Integer> updateOrderWithPush(OrderInfo orderInfo);

    /**
     * 端云计费
     * @param orderInfo
     * @param parkConfig
     * @return
     */
    ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(OrderInfo orderInfo, ParkConfig parkConfig, String channelId);
    ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(OrderInfo orderInfo, ParkConfig parkConfig);

    /**
     * 端云计费2
     * @param queryOrderFeeRequest
     * @return
     */
    ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(QueryOrderFeeRequest queryOrderFeeRequest);

    /**
     * 根据车牌模糊匹配在场记录
     * @param parkId
     * @param plateNum
     * @param inoutCode
     * @return
     */
    ObjectResponse<OrderInfo> fuzzyPlate(Long parkId, String inoutCode, String plateNum);
    /**
     * 根据车牌模糊匹配在场记录(去除第一个汉字)
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<OrderInfo> fuzzyPlate(Long parkId,String plateNum);

    /**
     * 根据车牌模糊匹配订单
     * @param parkId
     * @param plateNum
     * @param status
     * @param plot
     * @return
     */
    ObjectResponse<OrderInfo> fuzzyOrderPlate(long parkId, String plateNum, int status, int plot);

    ObjectResponse<Void> pncQueryFee(QueryOrderFeeRequest queryOrderFeeRequest);
    /**
     * 获取公众号的订单记录
     * @return
     */
    ObjectResponse<List<OrderDto>> getMpOrderList(OrderQueryRequest orderQueryRequest);

    ObjectResponse<List<OrderInfoDto>> getMpOrders(OrderQueryRequest orderQueryRequest);

    /**
     * 获取公众号的订单记录
     * @param type
     * @param id
     * @return
     */
    ObjectResponse getMpOrderDetail(Integer type ,Long id);

    /**
     * 统计车场的在场车辆数量
     * @param parkId
     * @return
     */
    ObjectResponse<Integer> countEnterCar(Long parkId);
    /**
     * 根据车牌模糊匹配离场记录
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<OrderInfo> fuzzyOutPlate(Long parkId, String plateNum);

    /**
     * 获取车牌类型
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<PlateTypeDto> getPlateType(Long parkId, String plateNum);
    ObjectResponse<PlateTypeDto> getPlateType(Long parkId, String plateNum, Long regionId);



    /**
     * 添加数据
     * 车牌置信度低人工修正表
     * @param madePlate
     * @return
     */
    ObjectResponse addMadePlate(MadePlate madePlate);

    /**
     * 通过订单号查数据
     * 车牌置信度低人工修正表
     * @param orderNum
     * @return
     */
    ObjectResponse<MadePlate> findMadePlateByOrderNum(String orderNum);

    /**
     * 更新对应数据
     * 车牌置信度低人工修正表
     * @param madePlate
     * @return
     */
    ObjectResponse updateMadePlate(MadePlate madePlate);

    /**
     * 修正记录表中添加修正记录数据
     * @param orderModifyRecord
     * @return
     */
    ObjectResponse addOrderModifyReocrd(OrderModifyRecord orderModifyRecord);


    /**
      * @Author zhangpengzhan
      * @Description // 二次识别结果通过接口函数
      * @Date 2020/7/3
      * @Param [orderNum, newPlateNum, newReliability, newCarType]
      * @Return com.icetech.common.domain.response.ObjectResponse
      **/

    ObjectResponse checkSecRecognition(String orderNum,String newPlateNum,int newReliability,int newCarType);

    /**
     * 储值卡扣费并更新交易记录完整流程方法
     * @param queryOrderFeeResponse 扣费信息
     * @param orderNum  订单号
     * @param parkId  车场表 主键 id
     * @return 扣费结果信息
     */
    ObjectResponse<StoreCard> chargeStoreCardComplete(QueryOrderFeeResponse queryOrderFeeResponse, String orderNum , Long parkId, String channelCode);

    /**
     * 根据ID查询修改记录
     * @param id
     * @return
     */
    ObjectResponse<OrderModifyRecord> selectModifyRecordById(Long id);

    /**
     * 批量离场
     * @param orderNums
     * @param oddStatus
     * @param username
     * @return
     */
    ObjectResponse batchExitOrder(List<String> orderNums, Integer oddStatus, String username);
    /**
     * 查询订单数
     * @return
     */
    ObjectResponse<Integer> findTheMaxIdByDate( Long parkId,String startTime,String endTime);

    /**
     * 根据订单号列表查询
     * @param orderNumList
     * @return
     */
    List<OrderInfo> selectListByOrderNums(Collection<String> orderNumList);

    /**
     * 分页获取订单信息
     * @param parkId
     * @param request
     * @param orderType 1= 在场 2=离场
     * @return
     */
    ObjectResponse<Page<OrderInfo>> getOrderInfoList(Long parkId, BaseQueryRequest request,Integer orderType);
    ObjectResponse<Page<OrderInfo>> getOrderInfoList(Long parkId, String plateNum, BaseQueryRequest request,Integer orderType);


    /**
     * 通过车场id和车场牌号查询最近一次在场车辆
     *
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<OrderInfo> getOneOrderInfo(Long parkId, String plateNum);

    /**
     * 通过车牌模糊搜索在场车辆
     *
     * @param parkId 车场id
     * @param plateNum 车牌号(京A1)
     * @param pageNo 第几页
     * @param pageSize 每页多少条
     * @return
     */
    Page<OrderInfo> getOrderPageBy(Long parkId, String plateNum, Integer pageNo, Integer pageSize);

    /**
     * 通过id和连续三位车牌搜索在场车场
     *
     * @param parkId
     * @param plateNums
     * @return
     */
    ObjectResponse<List<OrderInfo>> getEnterCars(Long parkId, List<String> plateNums);

    /**
     * 通过车场id和大于首条登记时间统计进场数
     *
     * @param parkId
     * @param createTime
     * @return
     */
    ObjectResponse<Integer> getCountBy(Long parkId, String createTime);

    /**
     * 获取实际可以盘点的数据
     *
     * @param parkId
     * @param createTime
     * @return
     */
    ObjectResponse<Integer> getSurplusCount(Long parkId, String createTime);

    /**
     * 获取实际可以盘点的数据列表
     *
     * @param parkId
     * @param createTime
     * @return
     */
    ObjectResponse<List<OrderVO>> getSurplusList(Long parkId, String createTime);

    /**
     * 获取七日前在场车辆数
     *
     * @param parkId
     * @param crateTime
     * @return
     */
    ObjectResponse<Integer> getLiveCountBy(Long parkId, String crateTime);

    /**
     * 获取在场车位信息
     * @param parkId
     * @return
     */
    ObjectResponse<InParkNumInfoResponse> getInParkNum(Long parkId);

    /**+
     * 获取先离场后付费订单
     *
     * @param tradeNo 交易单号
     * @param status 状态
     * @return
     */
    ObjectResponse<OrderAfterPay> getOrderAfterPayByTradeNo(String tradeNo,Integer status);

    /**
     * 获取指定时间离场车辆数
     *
     * @param startTime 离场开始时间
     * @param endTime 离场结束时间
     * @return
     */
    ObjectResponse<Integer> getExitCarNums(Long startTime, Long endTime);

    /**
     * 查询指定时间段离场车场信息
     *
     * @param parkId 必填
     * @param startTime
     * @param endTime
     * @return
     */
    ObjectResponse<List<OrderInfo>> selectExitOrderBy(Long parkId, Long startTime, Long endTime);

    /**
     * Description: 更改车辆类型
     * Version1.0 2024-02-25 by wgy 创建
     *
     * @param orderNums     订单编号
     * @param type          车辆类型
     * @return com.icetech.common.domain.response.ObjectResponse<java.lang.Boolean>
     */
    ObjectResponse<Boolean> updateOrderType(List<String> orderNums, Integer type);

    /**
     * 统计订单数据
     * @param orderQueryRequest
     * @return
     */
    ObjectResponse<OrderCountDto> countMpOrderList(OrderQueryRequest orderQueryRequest);

    /**
     * 批量添加在场车辆
     *
     * @param result
     * @param flag
     * @param park
     * @param userName
     * @param parkRegions
     * @return
     */
    ObjectResponse batchAddLiveCar(List<OrderAddRequest> result, Boolean flag, Park park, String userName, List<ParkRegion> parkRegions);
    /**
     * 根据本地订单号查询，包括历史表
     * @param parkId 车场ID
     * @param localOrderNum 本地订单号
     * @return 订单信息
     */
    OrderInfo getByLocalOrderNumWithHistory(Long parkId, String localOrderNum);

    /**
     * 获取新能源在场车辆数
     *
     * @param parkId
     * @return
     */
    Integer getChargeLiveCount(Long parkId);


    /**
     * 获取新能源在场车辆数
     *
     * @param parkId
     * @return
     */
    Integer getOilLiveCount(Long parkId);

    /**
     * 通过车场id获取在场车辆车牌号
     *
     * @param parkId
     * @param limitNum
     * @return
     */
    List<String> getLiveCarPlateNums(Long parkId, Integer limitNum);

    /**
     * 手动离场
     *
     * @param statusParam 离场参数
     * @return obj
     */
    ObjectResponse<Object> orderExit(OrderStatusParam statusParam);

    /**
     * 入场修改
     *
     * @param statusParam 离场参数
     * @return obj
     */
    ObjectResponse<Object> modifyEnter(OrderStatusParam statusParam);
}
