package com.icetech.cloudcenter.api.order;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.dto.OrderRefundRecordDTO;
import com.icetech.park.domain.request.OrderRefundParam;
import com.icetech.park.domain.request.RefundParam;
import com.icetech.park.domain.request.RefundRecordParam;

import java.util.List;
import java.util.Map;

public interface OrderRefundService {

    /**
     * 订单退款
     *
     * @param param 请求参数
     * @return obj
     */
    ObjectResponse<Object> orderRefund(OrderRefundParam param);

    /**
     * 订单退款
     *
     * @param param 请求参数
     * @return obj
     */
    ObjectResponse<Map<String, Object>> getOrderRefundList(RefundParam param, List<Long> parkIds);


    /**
     * 订单退款审核
     *
     * @param param 请求参数
     * @return obj
     */
    ObjectResponse<Object> orderRefundAudit(OrderRefundParam param);

    /**
     * 订单退款记录
     *
     * @param param 请求参数
     * @return obj
     */
    ObjectResponse<Page<OrderRefundRecordDTO>> orderRefundRecord(RefundRecordParam param);
}
