package com.icetech.cloudcenter.api.order;

import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.pay.MiniOrdersDTO;
import com.icetech.park.domain.dto.InvoiceParksDto;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.cloudcenter.domain.order.OrderPayWayDto;
import com.icetech.cloudcenter.domain.order.SumOrderDatePayDto;
import com.icetech.cloudcenter.domain.order.SumOrderPayDto;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.pay.PayTo;
import com.icetech.cloudcenter.domain.request.*;
import com.icetech.cloudcenter.domain.response.*;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.report.domain.vo.ParkPayReportVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface OrderPayService {
    /**
     * 根据订单号查询支付订单 此方法有问题
     * @param ordeNum
     * @return
     */
    @Deprecated
    ObjectResponse<OrderPay> selectOrderPayByOnum(String ordeNum);
    /**
     * 根据订单号查询支付订单多条记录
     * @param orderNum
     * @return
     */
    ObjectResponse<List<OrderPay>> selectByOrderNum(String orderNum);
    /**
     * 添加交易记录
     * @param orderPay
     * @return 支付记录ID
     */
    ObjectResponse<Long> addOrderPay(OrderPay orderPay);

    /**
     * 查询返回一条交易记录
     * @param orderPay
     * @return
     */
    ObjectResponse<OrderPay> findOne(OrderPay orderPay);

    /**
     * 修改订单交易
     * @param orderPay
     * @return
     */
    ObjectResponse<Integer> modifyOrderPay(OrderPay orderPay);

    ObjectResponse<Integer> updateOrderPayWithPush(OrderPay orderPay);

    /**
     * 完成支付，并使用优惠
     * @return
     */
    ObjectResponse<Integer> finishPayAndDiscount(OrderPay orderPay);

    ObjectResponse<Integer> finishPayAndDiscount(OrderPay orderPay, String parkCode, String channelCode);

    /**
     * 欠费追缴订单完成-电子缴费
     * @param payTo
     * @return
     */
    ObjectResponse<Void> finishPayNotPay(PayTo payTo);

    /**
     * 欠费追缴完成-现金缴费
     * @param payCashNotPay
     * @return
     */
    ObjectResponse<Void> finishPayNotPay(PayCashNotPay payCashNotPay, Integer payChannel);

    /**
     * 查询结果集
     * @param payPageQuery
     * @return
     */
    ObjectResponse<List<OrderPay>> findList(PageQuery<OrderPay> payPageQuery);

    /**
     * 收入汇总
     * @param flowRequest
     * @return
     */
    ObjectResponse<IncomeCountDto> incomeCount(FlowRequest flowRequest);

    /**
     * 收入明细countParkingTime
     * @param flowRequest
     * @return
     */
    ObjectResponse<List<IncomeDetailDto>> incomeDetail(FlowRequest flowRequest);

    /**
     * 按支付方式统计
     * @param flowRequest
     * @return
     */
    ObjectResponse<List<PayWayCountDto>> payWayCount(FlowRequest flowRequest);

    /**
     * 按支付方式统计
     * @param flowRequest
     * @param day 2=昨天 3=今天 7=7天  30=30天 0=其他 默认3
     * @param month 指定月份(yyyy-MM)
     * @return
     */
    ObjectResponse<List<PayWayCountDto>> payWayCount(FlowRequest flowRequest,int day,String month);

    /**
     * 车主端-财务报表-临停支付
     * @param parkIds
     * @param startTime
     * @param endTime
     * @return
     */
    ObjectResponse<List<PayWayCountDto>> countReportPay(String parkIds,String startTime, String endTime);

    /**
     * 储值卡报表
     * @param parkIds
     * @param startTime
     * @param endTime
     * @return
     */
    ObjectResponse<StoreCardCountDto> countStoreCardReport(List<Long> parkIds, String startTime, String endTime);

    /**
     * 停车场收入排名
     * @param parkIncomeTopRequest
     * @return
     */
    ObjectResponse<List<ParkIncomeTopDto>> parkIncomeTop(ParkIncomeTopRequest parkIncomeTopRequest);

    /**
     * 收费渠道排名
     * @param paywayTopRequest
     * @return
     */
    ObjectResponse<List<PaywayTopDto>> paywayTop(PaywayTopRequest paywayTopRequest);

    /**
     *  今日凌晨 按小时统计车场的营收
     * @param parkIdList eg: "1,2,3,4" / "all" 为查询所有的车场信息
     * @return
     */
    ObjectResponse<List<IncomeCountHourDto>> countTodayIncome(String parkIdList);

    /**
     *  近24小时 按小时统计车场的营收
     * @param parkIdList eg: "1,2,3,4" / "all" 为查询所有的车场信息
     * @return
     */
    ObjectResponse<List<IncomeCountHourDto>> count24HoursIncome(String parkIdList);


    /**
     * 临时车支付列表-统计
     * @param parkIds
     * @param day
     * @param day
     * @return
     */
    ObjectResponse<List<OrderPayWayDto>> countTemPayType(String parkIds, Integer day, String pointMonth);

    ObjectResponse<List<OrderPayDto>> getOrderPayList(OrderPayQueryRequest orderPayQueryRequest);

    /**
     * 统计交易明细列表(金额和条数)
     * @return
     */
    ObjectResponse<Map<String, Object>> countOrderPayList(OrderPayQueryRequest orderPayQueryRequest);

    /**
     * 获取交易明细详情
     * @param parkCode
     * @param recordId
     * @return
     */
    ObjectResponse<OrderPayDto> getOrderPayDetail(String parkCode,Integer recordId, String tradeNo);

    /**
     * 获取已缴费信息
     * @param orderNum
     * @return
     */
    ObjectResponse<OrderSumFeeDto> getSumFee(String parkCode,String orderNum);

    /**
     * 按条件汇总
     * @param orderPayCondition
     * @return
     */
    ObjectResponse<OrderSumFeeDto> getSumPay(OrderPayCondition orderPayCondition);
    /**
     * 汇总
     * @param sumOrderPayRequest
     * @return
     */
    ObjectResponse<SumOrderPayDto> sumOrderPay(SumOrderPayRequest sumOrderPayRequest);

    /**
     * 财务报表-收入汇总-非当天
     * @param
     * @return
     */
    ObjectResponse<SumOrderPayDto> summaryReportPay(String parkIds ,String startTime,String endTime);

    /**
     * 多方式汇总
     * @param
     * @return
     */
    ObjectResponse<List<SumOrderDatePayDto>> sumOrderPayMtype(BossOrderPayRequest bossOrderPayRequest);

    /**
     * 获取所有未开票的订单记录
     * @param invoiceRequest
     * @return
     */
    ObjectResponse<List<InvoiceResponse>> getInvoiceList(InvoiceRequest invoiceRequest);

    ObjectResponse<List<InvoiceResponse>> getMpInvoiceList(InvoiceRequest invoiceRequest);

    /**
     * 获取临停开票订单
     * @param invoiceRequest
     * @return
     */
    ObjectResponse<List<InvoiceResponse>> getInvoiceListV2(InvoiceRequest invoiceRequest);

    /**
     * 获取所有未开票的车场列表
     * @param invoiceRequest
     * @return
     */
    ObjectResponse<List<InvoiceParksDto>> getInvoiceParkList(InvoiceRequest invoiceRequest);

    /**
     * 获取用户可开票车场信息
     * @param invoiceRequest
     * @return
     */
    ObjectResponse<List<InvoiceParksDto>> getInvoiceParkListV2(InvoiceRequest invoiceRequest);

    ObjectResponse<OrderPay> getByTradeNo(String tradeNo);

    /**
     * 根据交易流水号获取交易明细
     * @param tradeNos
     * @return
     */
    ObjectResponse<List<OrderPay>> getListByTradeNos(List<String> tradeNos);

    /**
     * 查询包括历史表的订单数据
     * @param tradeNos 交易流水号
     * @return
     */
    ObjectResponse<List<OrderPay>> getListWithHistoryByTradeNos(List<String> tradeNos);

    /**
     *  更新开票状态为已开票
     * @param tradeNos 交易流水号列表
     * @return 更新结果
     */
    ObjectResponse<Void> batchUpdateInvoiceStatus(List<String> tradeNos);


    /**
     * 获取所有已提交开票申请的记录
     * @param invoiceRequest
     * @return
     */
    ObjectResponse<PageResult<List<InvoiceQueryResponse>>> getInvoiceList(InvoiceQueryRequest invoiceRequest);

    /**
     * 使用优惠
     * @param orderPay
     * @return
     */
    boolean useDiscount(OrderPay orderPay);

    /**
     *
     * @param discountPrice
     * @param tradeNo
     * @param payTime
     * @param discountNos
     */
    boolean useDiscount(Long parkId, String orderNum, Double discountPrice,String tradeNo, Long payTime,List<String> discountNos, OrderPay orderPay);

    /**
     * 分页获取支付信息
     * @param parkId
     * @param request
     * @return
     */
    ObjectResponse<Page<OrderPay>> getOrderPayList(Long parkId, BaseQueryRequest request);


    /**
     * 获取临停支付金额
     *
     * @param parkId
     * @param startTime
     * @param endTime
     * @param payType
     * @param plateNumber
     * @param paymentType
     * @return
     */
    ObjectResponse<BigDecimal> getTempPayAmount(Long parkId, Long startTime, Long endTime, List<Integer> payType, String plateNumber, Integer paymentType);

    /**
     * 获取支付了的支付渠道
     * @param startTime 支付开始时间
     * @param endTime 支付结束时间
     * @return
     */
    ObjectResponse<Integer> getPayAisle(Long startTime, Long endTime);

    /**
     * 获取电子支付明细列表-月
     *
     * @param startTime
     * @param endTime
     * @return
     */
    ObjectResponse<List<ParkPayReportVo>> getMonthPayList(String startTime, String endTime);

    /**
     * 获取电子支付明细列表-年
     *
     * @param startTime
     * @param endTime
     * @return
     */
    ObjectResponse<List<ParkPayReportVo>> getYearPayList(String startTime, String endTime);

    /**
     * 获取支付订单记录
     *
     * @param parkId 车场id
     * @param orderNums 订单编号
     * @param payStatus 支付状态:不传默认查已支付的
     * @return
     */
    ObjectResponse<List<OrderPay>> getOrderPayListBy(Long parkId, List<String> orderNums, Integer payStatus);

    /**
     * 欠费追缴订单完成-电子缴费
     * @return
     */
    ObjectResponse<Void> finishPayNotPay(MiniOrdersDTO dto, String bankOrderId);
}
