package com.icetech.cloudcenter.api.order;

import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.OrderEnexQueryRequest;
import com.icetech.cloudcenter.domain.response.EnexCountDto;
import com.icetech.cloudcenter.domain.response.EnexDetailDto;
import com.icetech.cloudcenter.domain.response.EnterMatchDto;
import com.icetech.cloudcenter.domain.response.ParkEnterOrexitCountDto;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.Collection;
import java.util.List;

/**
 * Description : 车辆进出场接口
 * @author fangct
 */
public interface OrderCarInfoService {
    /**
     * 车辆进出场汇总
     * @param flowRequest
     * @return
     */
    ObjectResponse<EnexCountDto> enexCount(FlowRequest flowRequest);

    /**
     * 进出流量明细
     * @param flowRequest
     * @return
     */
    ObjectResponse<List<EnexDetailDto>> enexDetail(FlowRequest flowRequest);

    /**
     * 统计近1/7/30天的车辆的进出场数量
     * @param parkIdList
     * @param day
     * @return
     */
    ObjectResponse<List<ParkEnterOrexitCountDto>> countDaysEnterOrExitNum(String parkIdList, Integer day);
    /**
     * 统计按天、指定月统计
     * @param parkIdList
     * @param day
     * @return
     */
    ObjectResponse<List<ParkEnterOrexitCountDto>> countDaysEnterOrExitNum(String parkIdList, Integer day,String monthCount);

    /**
     * 统计当前时间 上一个小时以内的进出口车辆
     * @param time
     * @return
     */
    ObjectResponse countHoursEnterOrExitNum(String time);

    /**
     * 获取入场匹配信息
     * @param orderEnexQueryRequest
     * @return
     */
    ObjectResponse<List<EnterMatchDto>> getEnterMatchList(OrderEnexQueryRequest orderEnexQueryRequest);

    /**
     * 查询记录
     * @param orderNum
     * @param parkId
     * @return
     */
    ObjectResponse<OrderCarInfo> getCarInfo(String orderNum, Long parkId);

    /**
     * 添加记录
     * @param carInfo
     * @return
     */
    ObjectResponse<String> addCarInfo(OrderCarInfo carInfo);

    /**
     * 更新记录
     * @param carInfo
     * @return
     */
    ObjectResponse<Integer> updateCarInfo(OrderCarInfo carInfo);

    /**
     * 批量获取订单信息
     * @param orderNums
     * @param parkId
     * @return
     */
    ObjectResponse<List<OrderCarInfo>> getCarInfoList(Collection<String> orderNums, Long parkId);
    /**
     * 查询子订单详情记录
     * @param orderSonId
     * @return
     */
    ObjectResponse<OrderSonCarInfo> getOrderSonCarInfo(Long orderSonId);

    /**
     * 带历史表查询子订单详情记录
     * @param orderNum 订单号
     * @return 详情
     */
    OrderCarInfo getByOrderNumWithHistory(String orderNum);

    /**
     * 查询子订单详情记录
     * @param orderNum 订单号
     * @return 详情
     */
    OrderCarInfo getByOrderNum(String orderNum);

    /**
     * 带历史表 根据ID更新
     * @param updateCarInfo 详情
     * @return 影响行数
     */
    int updateByIdWithHistory(OrderCarInfo updateCarInfo);

}
