package com.icetech.cloudcenter.api.order;

import com.icetech.cloudcenter.domain.request.OrderAuthQueryRequest;
import com.icetech.cloudcenter.domain.response.OrderAuthDto;
import com.icetech.order.domain.entity.OrderAuthInfo;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * Description : 订单授权服务接口
 * @author zys
 */
public interface OrderAuthService {
    /**
     * 修改授权订单
     * @param orderAuthInfo
     * @return
     */
    ObjectResponse upOrderAuth(OrderAuthInfo orderAuthInfo);
    /**
     * 新增授权订单
     * @param orderAuthInfo
     * @return
     */
    ObjectResponse addOrderAuth(OrderAuthInfo orderAuthInfo);
    /**
     * 根据授权码查询
     * @param authNum
     * @return
     */
    ObjectResponse<OrderAuthDto> selectOrderByAuthNum(String authNum);
    /**
     * 根据订单号查询
     * @param orderNum
     * @param status 1=已授权  0=未授权
     * @return
     */
    ObjectResponse<OrderAuthDto> selectOrderByOrderNum(String orderNum,Integer status);

    /**
     * 分页查询
     * @return
     */
    ObjectResponse<List<OrderAuthDto>> getOrderAuthList(OrderAuthQueryRequest orderAuthQueryRequest);

    /**
     * 分页查询
     * @return
     */
    ObjectResponse countOrderAuthList(OrderAuthQueryRequest orderAuthQueryRequest);
}
