package com.icetech.cloudcenter.api.order;

import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * Description : 车辆进场服务接口
 * @author fangct
 */
public interface CarOrderEnterService {

    /**
     * 车辆进场业务
     * @param enterRequest 请求参数
     * @return 响应
     */
    default ObjectResponse<CarEnterResult> enter(CarEnterRequest enterRequest){
        return ObjectResponse.success();
    };

    /**
     * 发送本地坐席的入场通知
     * 需要判断通道权限，所以需要在通道判断发送消息
     * @param enterRequest 请求参数
     * @param allow 是否允许进出
     */
    void sendWebsocketMessage(CarEnterRequest enterRequest,Integer allow);
}
