package com.icetech.cloudcenter.api.month;

import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * VIP类型关联区域表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-11-04
 */
public interface VipRegionService extends IBaseService<VipRegion> {

    /**
     * Description: 根据ID查询 VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param id 对象id
     * @return VipRegion
     */
    VipRegion getVipRegionById (Long id);

    /**
     * Description: 新增  VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addVipRegion (VipRegion entity);

    /**
     * Description: 修改 VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyVipRegion (VipRegion entity);

    /**
     * Description: 删除  VIP类型关联区域表对象信息 <br>
     * Version1.0 2021-11-04 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeVipRegionById (Long id);

    /**
     * 通过vipTypeId获取vip区域
     * @param vipTypeId
     * @return
     */
    List<VipRegion> getVipRegionsListByVipTypeId(Integer vipTypeId);

    /**
     * 通过vipId和billId获取单条计费规则
     * @param vipTypeId
     * @param regionId
     * @return
     */
    VipRegion getOneByVipTypeIdAndRegionId(Integer vipTypeId, Long regionId);
}
