package com.icetech.cloudcenter.api.constants;

/**
 * Description mq 常量配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/4/30 3:27 PM
 */
public class MqConstants {

    /**
     * 交换机
     */
    public static class Exchange {

        /**
         * 云翌相关交换机
         */
        public static final String YUNEASY_EXCHANGE = "yuneasy.exchange";

        /**
         * 通知交换机
         */
        public static final String NOTIFY_EXCHANGE = "notify.exchange";

        /**
         * 通道延迟交换机
         */
        public static final String AISLE_DELAYED_EXCHANGE = "aisle.delayed.exchange";

        /**
         * 脱机记录延迟交换机
         */
        public static String OFFLINE_RECORDS_DELAYED_EXCHANGE = "offline.records.delayed.exchange";

    }

    /**
     * 路由
     */
    public static class Routing {

        /**
         *  云翌呼叫信息路由
         */
        public static final String YUNEASY_CALL_INFO_ROUTING = "yuneasy.call.info.routing";

        /**
         * 通道告警路由
         */
        public static final String AISLE_ALARM_ROUTING = "aisle.duration.alarm.routing";
        /**
         * 通道告警路由
         */
        public static final String BATCH_DOWN_SEND_ROUTING = "batch.down.send.routing";
        /**
         * 通道需支付路由
         */
        public static final String AISLE_NEED_PAY_ROUTING = "aisle.need.pay.routing";
        /**
         * 通道需支付路由
         */
        public static final String APPLY_CAR_VIDEO_ROUTING = "apply.car.video.routing";
        /**
         * 邮件通知
         */
        public static final String NOTIFY_VIP_EMAIL_ROUTING = "notify.vip.email.routing";
        /**
         * 优惠核销通知
         */
        public static final String NOTIFY_DISCOUNT_ROUTING = "notify.discount.routing";
        /**
         * 正式环境消息转发到灰度
         */
        public static final String PROD_RESP_ROUTING = "prod.resp.routing";
        /**
         * 脱机记录路由
         */
        public static final String OFFLINE_RECORDS_ROUTING = "offline.records.routing";

    }

    /**
     * 队列
     */
    public static class Queues {
        public static final String YUNEASY_CALL_ALARM = "yuneasyCallAlarm";
        public static final String AISLE_DURATION_ALARM = "aisleDurationAlarm";
        public static final String OFFLINE_RECORDS_QUEUE = "offlineRecords.queue";
        public static final String BATCH_DOWN_SEND = "batchDownSend";
        public static final String PROD_RESP = "prod.resp.queue";
        public static final String AISLE_NEED_PAY = "aisle.need.pay.queue";
        public static final String APPLY_CAR_VIDEO = "apply.car.video.queue";
        /**
         * vip开通邮箱通知队列
         */
        public static final String NOTIFY_VIP_EMAIL = "notifyVipEmail";
        /**
         * 优惠核销
         */
        public static final String DISCOUNT_PAY = "discountPay";
        /**
         * 优惠核销
         */
        public static final String DISCOUNT_EXIT = "discountExit";

        /**
         * app 应用信息同步
         */
        public static final String ICE_APP_INFO_SYNC_QUEUE = "ice.app.info.sync.queue";
    }
}
