package com.icetech.cloudcenter.api.car;


import com.icetech.park.domain.entity.car.CarClean;
import com.icetech.park.domain.entity.car.CarRegister;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * 对外暴露接口 盘点车辆登记表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-08-23
 */
public interface ICarRegisterService {

    /**
     * 检验该车场的该车位是否可以登记
     *
     * @param parkId
     * @param plateNum
     * @return
     */
    Boolean checkPlateNumIsRegister(Long parkId, String plateNum);


    /**
     * 保存登记车辆
     *
     * @param carRegister
     * @return
     */
    ObjectResponse<CarRegister> save(CarRegister carRegister);


    /**
     * 登记分页
     *
     * @param parkId
     * @param plateNum
     * @param pageNo
     * @param pageSize
     * @param type
     * @param startTime
     * @param endTime
     * @return
     */
    Page<CarRegister> getRegisterPage(Long parkId, String plateNum, Integer pageNo, Integer pageSize, Integer type, String startTime, String endTime);

    /**
     * 通过id获取登记信息
     *
     * @param id
     * @return
     */
    ObjectResponse<CarRegister> findById(Long id);


    /**
     * 通过车场id获取当次登记车场
     *
     * @param parkId
     * @return
     */
    ObjectResponse<Integer> getCurrentRegisterCarNum(Long parkId);

    /**
     * 通过车场id获取当期盘点记录最早一条记录
     *
     * @param parkId
     * @return
     */
    ObjectResponse<CarRegister> getRegisterOneBy(Long parkId);

    /**
     * 获取车辆盘点清理记录分页
     *
     * @param parkId
     * @param plateNum
     * @param pageNo
     * @param pageSize
     * @param startTime
     * @param endTime
     * @return
     */
    Page<CarClean> getCleanPage(Long parkId, String plateNum, Integer pageNo, Integer pageSize, String startTime, String endTime);

    /**
     * 通过id获取盘点记录详情
     *
     * @param id
     * @return
     */
    ObjectResponse<CarClean> getCleanDetail(Long id);

    /**
     * 获取当次登记的未清理列表
     *
     * @param parkId
     * @param batchCode
     * @return
     */
    ObjectResponse<List<CarRegister>> getCarRegisterListBy(Long parkId, String batchCode);

    /**
     * 批量修改登记车辆为已登记
     *
     * @param parkId        车场id
     * @param batchCode     批次号
     * @return
     */
    ObjectResponse<Boolean> batchUpdateCarRegisters(Long parkId, String batchCode);


    /**
     * 保存清理记录
     *
     * @param carCleanList
     * @return
     */
    ObjectResponse<Boolean> saveAllCarClean(List<CarClean> carCleanList);

    /**
     * 清理冗余数据
     *
     * @param parkId
     * @param batchCode
     * @param carCleanList
     * @return
     */
    ObjectResponse cleanCar(Long parkId, String batchCode, List<CarClean> carCleanList);
}
