package com.icetech.cloudcenter.api;

import com.icetech.common.domain.Page;
import com.icetech.order.domain.dto.NotPayRecordQueryDTO;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.cloudcenter.domain.notpay.*;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.vo.NotPayPage;

import java.util.List;

/**
 * Description : 欠费订单查询
 *  @author fangct
 */
public interface NotPayService {

    /**
     * Description: 查询欠费订单
     * Version1.0 2023-03-23 by wgy 创建
     *
     * @param parkId        车场id
     * @param plateNum      车牌号
     * @param exType        出入口类型，1-入口，2-出口
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.cloudcenter.domain.entity.order.OrderNotpay>>
     */
    ObjectResponse<List<OrderNotpay>> queryNotPayFee(Long parkId, String plateNum, int exType);

    /**
     * Description: 查询欠费订单
     * Version1.0 2023-03-23 by wgy 创建
     *
     * @param id    id
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.cloudcenter.domain.entity.order.OrderNotpay>
     */
    ObjectResponse<OrderNotpay> getOrderNotpayById (Long id);

    /**
     * 删除欠费订单
     * @param notPayDeleteDTO 参数
     * @param operAccount 操作员
     * @return void
     */
    ObjectResponse<Void> delNotPayOrder(NotPayDeleteDTO notPayDeleteDTO, String operAccount);

    /**
     * Description: 查询补缴记录
     * Version1.0 2023-03-24 by wgy 创建
     *
     * @param queryDTO      查询参数
     * @param parkIds     车场Id
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.order.domain.vo.NotPayPage<com.icetech.cloudcenter.domain.notpay.NotPayOrderDetail>>
     */
    ObjectResponse<Page<OrderNotpay>> getNotPayRecord(NotPayRecordQueryDTO queryDTO, String parkIds);

    /**
     * Description: 查询补缴信息
     * Version1.0 2023-03-27 by wgy 创建
     *
     * @param orderNum  订单号
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.cloudcenter.domain.entity.order.OrderNotpay>
     */
    ObjectResponse<OrderNotpay> getOrderNotpayByOrderNum(String orderNum);
}
