package com.icetech.cloudcenter.api;

import com.icetech.cloudcenter.domain.request.BatchUpgradeRequest;
import com.icetech.cloudcenter.domain.response.BatchUpgradeValidateResponse;
import com.icetech.cloudcenter.domain.response.DeviceListDTO;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.domain.request.DeviceUpgradeRequest;
import com.icetech.cloudcenter.domain.request.FirmwareListRequest;
import com.icetech.cloudcenter.domain.request.SaveFirmwareRequest;
import com.icetech.cloudcenter.domain.request.UpgradeLogListRequest;
import com.icetech.cloudcenter.domain.response.FirmwareListResponse;
import com.icetech.cloudcenter.domain.response.SupportUpgradeDeviceResponse;
import com.icetech.cloudcenter.domain.response.UpgradeLogListResponse;
import com.icetech.cloudcenter.domain.response.ValidateUpgradeResponse;
import com.icetech.cloudcenter.domain.response.ValidateVersionResponse;

import java.util.List;

/**
 * 设备管理接口
 * @author fangct
 */
public interface IDeviceManageService {

    /**
     * 设备升级
     * @param deviceUpgradeRequest
     * @return
     */
    ObjectResponse upgrade(DeviceUpgradeRequest deviceUpgradeRequest);

    /**
     * 批量升级
     * @param batchUpgradeRequest
     * @return
     */
    ObjectResponse batchUpgrade(BatchUpgradeRequest batchUpgradeRequest);

    /**
     * 批量验证设备升级可行性
     * @param sns
     * @return
     */
    ObjectResponse<BatchUpgradeValidateResponse> batchUpgradeValidate(String sns);
    /**
     * 固件列表
     * @param firmwareListRequest
     * @return
     */
    ObjectResponse<Page<FirmwareListResponse>> firmwareList(FirmwareListRequest firmwareListRequest);
    /**
     * 保存固件信息
     * @param saveFirmwareRequest
     * @return
     */
    ObjectResponse saveFirmware(SaveFirmwareRequest saveFirmwareRequest);

    /**
     * 根据产品型号ID查询
     * @param productModelId
     * @return
     */
    ObjectResponse<List<String>> findByProductModelId(Integer productModelId);

    /**
     * 升级进度查询
     * @param taskId
     * @return
     */
    ObjectResponse upgradeProgress(String taskId);

    /**
     * 验证版本号是否重复
     *
     * @param productModelId
     * @param firmwareVersion
     * @return
     */
    ObjectResponse<ValidateVersionResponse> validateVersion(Integer productModelId, String firmwareVersion);

    /**
     * 验证是否可升级
     * @param sn
     * @return
     */
    ObjectResponse<ValidateUpgradeResponse> validateUpgrade(String sn);

    /**
     * 查询设备是否支持升级
     * @param deviceListDTO
     * @return
     */
    ObjectResponse<List<SupportUpgradeDeviceResponse>> supportUpgradeDevice(List<DeviceListDTO> deviceListDTO);

    /**
     * 重新升级
     * @param taskId
     * @return
     */
    ObjectResponse reUpgrade(String taskId);

    /**
     * 升级日志
     * @param upgradeLogListRequest
     * @return
     */
    ObjectResponse<Page<UpgradeLogListResponse>> upgradeLogList(UpgradeLogListRequest upgradeLogListRequest);
}
