package com.icetech.cloudcenter.api;

import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.domain.request.p2c.PropertySetRequest;

/**
 * @author fangct
 * 通用服务
 */
public interface ICommonService {

    /**
     * 属性设置
     * @param propertySetRequest
     * @param sn
     * @return
     */
    ObjectResponse propertySet(PropertySetRequest propertySetRequest, String sn);

    /**
     * 属性获取
     * @param sn
     * @return
     */
    ObjectResponse<PropertyInfoRequest> propertyGet(String sn, String topic);

    /**
     * 给设备下发消息
     * @param sn
     * @param message
     * @param cmd
     * @return
     */
    ObjectResponse<Void> down(String sn, Object message, String cmd);

    ObjectResponse<Void> commonDown(int deviceType, String sn, Object message, String cmd);
}
