package com.icetech.cloudcenter.api;

import com.icetech.cloudcenter.domain.request.BarriergateOperRequest;
import com.icetech.cloudcenter.domain.request.EnterDebugRequest;
import com.icetech.cloudcenter.domain.request.ExitDebugRequest;
import com.icetech.cloudcenter.domain.request.PayDebugRequest;
import com.icetech.cloudcenter.domain.request.ShowSayDebugRequest;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * 调试助手接口
 * @author fangct
 */
public interface DebugService {

    /**
     * 入场测试
     * @param enterDebugRequest
     * @param topic
     * @return
     */
    ObjectResponse enterDebug(EnterDebugRequest enterDebugRequest, String topic);

    /**
     * 出场测试
     * @param exitDebugRequest
     * @return
     */
    ObjectResponse exitDebug(ExitDebugRequest exitDebugRequest);

    /**
     * 支付测试
     * @param payDebugRequest
     * @return
     */
    ObjectResponse payDebug(PayDebugRequest payDebugRequest);

    /**
     * 请求屏显测试
     * @param showSayDebugRequest
     * @return
     */
    ObjectResponse showSayDebug(ShowSayDebugRequest showSayDebugRequest);

    /**
     * 请求开关闸
     * @param barriergateOperRequest
     * @return
     */
    ObjectResponse barriergateOper(BarriergateOperRequest barriergateOperRequest);
}
