/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.route;

import com.google.common.collect.Lists;
import com.icetech.common.domain.route.ServiceRouteInfo;
import com.icetech.mq.constants.Constant;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.web.bean.ServiceApiInfo;
import com.icetech.web.route.ApiMetaBuilder;
import com.icetech.web.route.ServiceRouteInfoBuilder;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class RequestMappingScan
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(RequestMappingScan.class);
    private static final ApiMetaBuilder apiMetaBuilder = new ApiMetaBuilder();
    @Autowired
    private RabbitSender rabbitSender;
    private static boolean runFlag = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Environment env = applicationContext.getEnvironment();
        boolean routeScan = (Boolean)env.getProperty("ice.route.scan", Boolean.class, (Object)false);
        if (!routeScan || runFlag) {
            return;
        }
        runFlag = true;
        String serviceId = env.getProperty("spring.application.name", "application");
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        ServiceApiInfo serviceApiInfo = apiMetaBuilder.getServiceApiInfo(serviceId, mapping);
        ServiceRouteInfoBuilder serviceRouteInfoBuilder = new ServiceRouteInfoBuilder(env);
        ServiceRouteInfo build = serviceRouteInfoBuilder.build(serviceApiInfo);
        this.rabbitSender.sendMessage("", "common.route.scan.queue", (Object)build, Long.valueOf(0L), (Collection)Lists.newArrayList((Object[])new String[]{Constant.platformMq}));
    }
}

