/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;

public class ContentCacheRequestWrapper
extends HttpServletRequestWrapper {
    protected HttpServletRequest request;
    protected byte[] cacheContent;
    protected ServletInputStream inputStream;
    protected BufferedReader reader;

    public ContentCacheRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.request = request;
        request.getParameterMap();
        this.cacheContent = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
        this.inputStream = new RequestCachingInputStream(this.cacheContent);
    }

    public String getParameter(String name) {
        return super.getParameter(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.inputStream, this.getCharacterEncoding()));
        }
        return this.reader;
    }

    public byte[] getCacheContent() {
        return this.cacheContent;
    }

    public void reset() throws IOException {
        this.inputStream.close();
        this.inputStream = new RequestCachingInputStream(this.cacheContent);
    }

    private static class RequestCachingInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public RequestCachingInputStream(byte[] bytes) {
            this.inputStream = new ByteArrayInputStream(bytes);
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public boolean isReady() {
            return true;
        }

        public boolean isFinished() {
            return this.inputStream.available() == 0;
        }

        public void setReadListener(ReadListener listener) {
        }
    }
}

