/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.aop;

import com.alibaba.fastjson.JSON;
import com.icetech.common.annotation.LogIgnore;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class ControllerLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerLogAspect.class);
    @Value(value="${ice.web.aop.controller-log.trunc-length:512}")
    private int truncLength;

    @Pointcut(value="execution( * com.icetech..controller..*(..)) && !@annotation(com.icetech.common.annotation.LogIgnore)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Signature signature = pjp.getSignature();
        if (!(signature instanceof MethodSignature)) {
            return pjp.proceed(pjp.getArgs());
        }
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        LogIgnore ignore = targetMethod.getDeclaringClass().getAnnotation(LogIgnore.class);
        if (ignore != null) {
            return pjp.proceed(pjp.getArgs());
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return pjp.proceed(pjp.getArgs());
        }
        long startTime = System.currentTimeMillis();
        ServletRequestAttributes attributes = (ServletRequestAttributes)requestAttributes;
        HttpServletRequest request = attributes.getRequest();
        String url = request.getRequestURL().toString();
        String prefix = "[" + url + "][" + request.getMethod() + "][" + signature.getDeclaringTypeName() + "." + signature.getName() + "]";
        Object result = null;
        try {
            log.info(prefix + "[receive:{}]", (Object)Arrays.toString(pjp.getArgs()));
            result = pjp.proceed();
            String content = JSON.toJSONString((Object)String.valueOf(result));
            log.info(prefix + "[T:{}][return:{}]", (Object)(System.currentTimeMillis() - startTime), (Object)(content.length() > this.truncLength ? content.substring(0, this.truncLength) + " ......" : content));
            return result;
        }
        catch (Exception e) {
            log.error(prefix + "[T:{}]\u6267\u884c\u5f02\u5e38", (Object)(System.currentTimeMillis() - startTime), (Object)e);
            throw e;
        }
    }
}

