package com.icetech.web.route;

import com.google.common.collect.Lists;
import com.icetech.common.domain.route.ServiceRouteInfo;
import com.icetech.mq.constants.Constant;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.web.bean.ServiceApiInfo;
import com.icetech.web.configuration.DefaultMvcConfiguration;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

/**
 * Description 自定义扫描注解
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0
 */
@SuppressWarnings("ALL")
@Slf4j
public class RequestMappingScan implements ApplicationListener<ContextRefreshedEvent> {

    private static final ApiMetaBuilder apiMetaBuilder = new ApiMetaBuilder();

    @Autowired
    private RabbitSender rabbitSender;
    
    private static boolean runFlag = false;

    public RequestMappingScan() {
    }

    /**
     * 初始化方法
     *
     * @param event
     */
    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Environment env = applicationContext.getEnvironment();
        boolean routeScan = env.getProperty(DefaultMvcConfiguration.ICE_ROUTE_SCAN, Boolean.class, false);
        if (!routeScan || runFlag) {
            return;
        }
        runFlag = true;
        // 服务名称
        String serviceId = env.getProperty("spring.application.name", "application");
        // 所有接口映射
        RequestMappingHandlerMapping mapping = applicationContext.getBean(RequestMappingHandlerMapping.class);
        ServiceApiInfo serviceApiInfo = apiMetaBuilder.getServiceApiInfo(serviceId, mapping);
        ServiceRouteInfoBuilder serviceRouteInfoBuilder = new ServiceRouteInfoBuilder(env);
        ServiceRouteInfo build = serviceRouteInfoBuilder.build(serviceApiInfo);
        rabbitSender.sendMessage("", Constant.COMMON_ROUTE_SCAN_QUEUE, build, 0L, Lists.newArrayList(Constant.platformMq));
    }
}
