package com.icetech.web.result;

import com.alibaba.fastjson.annotation.JSONField;
import com.icetech.web.exception.ServiceException;
import com.icetech.web.message.ServiceError;
import com.icetech.web.message.ServiceErrorEnum;
import com.icetech.web.message.ServiceErrorMeta;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 处理业务返回结果
 *
 * @author wgy
 */
@Slf4j
public class DefaultServiceResultBuilder implements ServiceResultBuilder {

    @Override
    public Object buildError(HttpServletRequest request, HttpServletResponse response, Throwable throwable) {
        ServiceError error;
        if (throwable instanceof ServiceException) {
            ServiceException serviceException = (ServiceException) throwable;
            error = serviceException.getError();
        } else {
            ServiceErrorMeta errorMeta = ServiceErrorEnum.ISP_UNKNOWN_ERROR.getErrorMeta();
            error = errorMeta.getError();
        }
        return this.buildError(error.getSub_code(), error.getSub_msg());
    }

    @Override
    public Object buildError(String subCode, String subMsg) {
        ErrorResult result = new ErrorResult();
        result.setSub_code(subCode);
        result.setSub_msg(subMsg);
        return result;
    }

    @Data
    public static class ErrorResult {
        @JSONField(ordinal = 1)
        private String sub_code;
        @JSONField(ordinal = 2)
        private String sub_msg;
    }
}
