package com.icetech.web.filter;

import com.icetech.token.utils.LoginHelper;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.*;
import java.io.IOException;

/**
 * <p>日志追踪器</p>
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0.5
 * @since Date 2021/7/26 10:01 上午
 */
@Slf4j
public class SaTokenFilter implements Filter {
    
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        } finally {
            LoginHelper.clearCache();
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("[SaTokenFilter 初始化完成]");
    }

    @Override
    public void destroy() {
        log.info("[SaTokenFilter 销毁]");
    }

}
