package com.icetech.web.aop.anno;


import com.icetech.common.constants.LogWarnTypeEnum;

import java.lang.annotation.*;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface TimeoutWarning {
    long DEFAULT_TIMEOUT = 5000;
    LogWarnTypeEnum DEFAULT_WARN_TYPE = LogWarnTypeEnum.监控埋点;

    /**
     * 超时时间(ms)
     */
    long timeout() default DEFAULT_TIMEOUT;

    /**
     * 报警类型
     */
    LogWarnTypeEnum warnType();

    /**
     * 消息内容
     */
    String message();

    /**
     * 自定义消息
     */
    String content() default "";

    /**
     * 自定义消息参数
     */
    String[] contentArgs() default {};
}
