/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.wrapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.StreamUtils;

public class HttpServletRequestDecorator
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletRequestDecorator.class);
    protected Map<String, String[]> paramMap;
    protected byte[] body;

    public HttpServletRequestDecorator(HttpServletRequest request) throws IOException {
        super(request);
        this.paramMap = new HashMap<String, String[]>(request.getParameterMap());
        this.body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public byte[] getCacheBody() {
        return this.body;
    }

    public String getParameter(String arg0) {
        String[] paramValues = this.getParameterValues(arg0);
        if (paramValues != null && paramValues.length > 0) {
            return paramValues[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.paramMap;
    }

    public Enumeration<String> getParameterNames() {
        return new IteratorWrapper<String>(this.paramMap.keySet().iterator());
    }

    public String[] getParameterValues(String arg0) {
        return this.paramMap.get(arg0);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamAdapter(this.body);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.body)));
    }

    protected boolean handleInputStream() throws IOException {
        if (this.body == null) {
            MediaType mt = this.getContentType(this.getRequest());
            if (mt != null && (MediaType.APPLICATION_JSON.isCompatibleWith(mt) || MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mt))) {
                ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
                byte[] buff = new byte[100];
                try (ServletInputStream in = this.getRequest().getInputStream();){
                    int rc;
                    while ((rc = in.read(buff, 0, 100)) > 0) {
                        swapStream.write(buff, 0, rc);
                    }
                }
                swapStream.flush();
                this.body = swapStream.toByteArray();
                swapStream.close();
                return true;
            }
            return false;
        }
        return true;
    }

    private MediaType getContentType(ServletRequest request) {
        String value = request.getContentType();
        return value != null ? MediaType.parseMediaType((String)value) : null;
    }

    protected void handleParam() {
        if (this.paramMap == null) {
            this.paramMap = new HashMap<String, String[]>(this.getRequest().getParameterMap());
        }
    }

    public void setParameters(Map<String, String[]> paramMap) {
        logger.debug("Cus set request parameter {}", paramMap == null ? "nil" : Integer.valueOf(paramMap.size()));
        if (MapUtils.isNotEmpty(paramMap)) {
            this.paramMap.putAll(paramMap);
        }
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String toString() {
        return "Common Request;" + this.getRequest().toString();
    }

    private static class ServletInputStreamAdapter
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public ServletInputStreamAdapter(byte[] bytes) {
            this.inputStream = new ByteArrayInputStream(bytes);
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public boolean isReady() {
            return true;
        }

        public boolean isFinished() {
            return this.inputStream.available() == 0;
        }

        public void setReadListener(ReadListener listener) {
        }
    }

    private static class IteratorWrapper<E>
    implements Enumeration<E> {
        private final Iterator<E> it;

        public IteratorWrapper(Iterator<E> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public E nextElement() {
            return this.it.next();
        }
    }
}

