/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.aop;

import com.google.common.collect.Lists;
import com.icetech.common.utils.JsonUtils;
import com.icetech.mq.constants.Constant;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.token.model.LoginUser;
import com.icetech.token.utils.LoginHelper;
import com.icetech.web.aop.anno.Log;
import com.icetech.web.bean.OperatorLogMsg;
import com.icetech.web.utils.ServletUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpMethod;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

@Aspect
@ConditionalOnClass(value={HttpServletRequest.class, RequestContextHolder.class, LoginHelper.class, RabbitSender.class})
public class AuditLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AuditLogAspect.class);
    @Resource
    private RabbitSender rabbitSender;
    private final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private final DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();

    @AfterReturning(pointcut="@annotation(auditLog)", returning="jsonResult")
    public void beforeMethod(JoinPoint joinPoint, Log auditLog, Object jsonResult) {
        this.handleLog(joinPoint, auditLog, null, jsonResult);
    }

    @AfterThrowing(value="@annotation(auditLog)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Log auditLog, Exception e) {
        this.handleLog(joinPoint, auditLog, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, Log auditLog, Exception e, Object jsonResult) {
        try {
            LoginUser loginUser = LoginHelper.getLoginUser();
            OperatorLogMsg operatorLogMsg = new OperatorLogMsg();
            operatorLogMsg.setStatus(1);
            String ip = ServletUtils.getClientIP();
            operatorLogMsg.setIp(ip);
            operatorLogMsg.setUrl(Objects.requireNonNull(ServletUtils.getRequest()).getRequestURI());
            if (loginUser != null) {
                operatorLogMsg.setPlatformType(loginUser.getPlatformType());
                operatorLogMsg.setUserId(loginUser.getUserId());
                operatorLogMsg.setUsername(loginUser.getUsername());
            }
            if (e != null) {
                operatorLogMsg.setStatus(0);
                operatorLogMsg.setErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            operatorLogMsg.setMethodName(className + "." + methodName + "()");
            operatorLogMsg.setRequestMethod(ServletUtils.getRequest().getMethod());
            this.getControllerMethodDescription(joinPoint, auditLog, operatorLogMsg, jsonResult);
            String operation = auditLog.operatorMsg();
            if (operation.contains("#")) {
                MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                Object[] args = joinPoint.getArgs();
                operation = this.getValBySpEL(operation, methodSignature, args);
            }
            operatorLogMsg.setOperationMsg(operation);
            operatorLogMsg.setOperationTime(new Date());
            this.rabbitSender.sendMessage("", "common.auditLog.queue", (Object)operatorLogMsg, Long.valueOf(0L), (Collection)Lists.newArrayList((Object[])new String[]{Constant.commonMq}));
        }
        catch (Exception exp) {
            log.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }

    private String getValBySpEL(String spEL, MethodSignature methodSignature, Object[] args) {
        String[] paramNames = this.nameDiscoverer.getParameterNames(methodSignature.getMethod());
        if (paramNames != null && paramNames.length > 0) {
            Expression expression = this.spelExpressionParser.parseExpression(spEL);
            StandardEvaluationContext context = new StandardEvaluationContext();
            for (int i = 0; i < args.length; ++i) {
                context.setVariable(paramNames[i], args[i]);
            }
            return expression.getValue((EvaluationContext)context).toString();
        }
        return null;
    }

    public void getControllerMethodDescription(JoinPoint joinPoint, Log log, OperatorLogMsg operatorLogMsg, Object jsonResult) throws Exception {
        operatorLogMsg.setBusinessType(log.businessType().ordinal());
        operatorLogMsg.setTitle(log.title());
        operatorLogMsg.setOperatorType(log.operatorType().ordinal());
        if (log.isSaveRequestData()) {
            this.setRequestValue(joinPoint, operatorLogMsg);
        }
        if (log.isSaveResponseData() && Objects.nonNull(jsonResult)) {
            operatorLogMsg.setJsonResult(StringUtils.substring((String)JsonUtils.toJsonString((Object)jsonResult), (int)0, (int)2000));
        }
    }

    private void setRequestValue(JoinPoint joinPoint, OperatorLogMsg operatorLogMsg) throws Exception {
        String requestMethod = operatorLogMsg.getRequestMethod();
        if (HttpMethod.PUT.name().equals(requestMethod) || HttpMethod.POST.name().equals(requestMethod)) {
            String params = this.argsArrayToString(joinPoint.getArgs());
            operatorLogMsg.setParam(StringUtils.substring((String)params, (int)0, (int)2000));
        } else {
            Map paramsMap = (Map)ServletUtils.getRequest().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            operatorLogMsg.setParam(StringUtils.substring((String)paramsMap.toString(), (int)0, (int)2000));
        }
    }

    private String argsArrayToString(Object[] paramsArray) {
        StringBuilder params = new StringBuilder();
        if (paramsArray != null && paramsArray.length > 0) {
            for (Object o : paramsArray) {
                if (!Objects.nonNull(o) || this.isFilterObject(o)) continue;
                try {
                    params.append(JsonUtils.toJsonString((Object)o)).append(" ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return params.toString().trim();
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iterator;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iterator2 = collection.iterator();
            if (iterator2.hasNext()) {
                Object value = iterator2.next();
                return value instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iterator = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry value;
            Map.Entry entry = value = iterator.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }
}

