package com.icetech.web.wrapper;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

import org.springframework.web.util.ContentCachingResponseWrapper;

public class HttpServletResponseDecorator extends ContentCachingResponseWrapper {
    //为了方便拦截器获取最终结果值，添加一个临时对象
    private final transient Map<String, String> transientHeader = new HashMap<String, String>();
    // 为了方便拦截器获取最终结果值，添加一个临时对象，http 状态码
    private transient int httpState = 200;

    /**
     * @param response
     */
    public HttpServletResponseDecorator(HttpServletResponse response) {
        super(response);
    }

    /**
     * header 临时对象
     *
     * @return the transientHeader
     */
    public Map<String, String> getTransientHeader() {
        return transientHeader;
    }

    /**
     * @return the httpState
     */
    public int getTransientHttpState() {
        return httpState;
    }

    @Override
    public void setHeader(String name, String value) {
        transientHeader.put(name, value);
        super.setHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        this.httpState = sc;
        super.setStatus(sc);
    }
}
