/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.swagger;

import com.alibaba.fastjson.JSON;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.RawField;
import com.google.common.base.Optional;
import com.icetech.common.utils.FileUtil;
import com.icetech.common.utils.StringUtils;
import com.icetech.web.aop.anno.BizCode;
import com.icetech.web.aop.anno.Open;
import com.icetech.web.bean.ServiceConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.validator.constraints.Length;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import springfox.documentation.service.Operation;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;

public class DocumentationPluginsManagerExt
extends DocumentationPluginsManager {
    private static final String SERVICE_NAME = "serviceName";
    private static final String ICE_VERSION = "ice_version";
    private static final String MODULE_ORDER = "module_order";
    private static final String API_ORDER = "api_order";
    private static final String BIZ_CODE = "biz_code";
    private static final String REQUEST_DEMO = "request_demo";
    private static final String NOTIFY_URL = "notify_url";

    public Operation operation(OperationContext operationContext) {
        Operation operation = super.operation(operationContext);
        this.setVendorExtension(operation, operationContext);
        return operation;
    }

    private void setVendorExtension(Operation operation, OperationContext operationContext) {
        List vendorExtensions = operation.getVendorExtensions();
        Optional mappingOptional = operationContext.findAnnotation(Open.class);
        if (mappingOptional.isPresent()) {
            Open open = (Open)mappingOptional.get();
            String name = open.value();
            String version = this.buildVersion(open.version());
            String requestDemo = open.requestDemo();
            vendorExtensions.add(new StringVendorExtension(SERVICE_NAME, name));
            vendorExtensions.add(new StringVendorExtension(ICE_VERSION, version));
            vendorExtensions.add(new StringVendorExtension(NOTIFY_URL, open.notifyUrl() ? "1" : "0"));
            this.setBizCode(open, vendorExtensions);
            this.setResultExtProperties(operationContext);
            this.setRequestDemo(name, requestDemo, vendorExtensions);
        }
        Optional apiOptional = operationContext.findControllerAnnotation(Api.class);
        int order = 0;
        if (apiOptional.isPresent()) {
            order = ((Api)apiOptional.get()).position();
        } else {
            Optional orderOptional = operationContext.findControllerAnnotation(Order.class);
            if (orderOptional.isPresent()) {
                order = ((Order)orderOptional.get()).value();
            }
        }
        vendorExtensions.add(new StringVendorExtension(MODULE_ORDER, String.valueOf(order)));
        Optional apiOperationOptional = operationContext.findAnnotation(ApiOperation.class);
        int methodOrder = 0;
        if (apiOperationOptional.isPresent()) {
            methodOrder = ((ApiOperation)apiOperationOptional.get()).position();
        }
        vendorExtensions.add(new StringVendorExtension(API_ORDER, String.valueOf(methodOrder)));
    }

    private void setResultExtProperties(OperationContext operationContext) {
        List vendorExtensions = operationContext.getDocumentationContext().getVendorExtentions();
        ResolvedType returnType = operationContext.getReturnType();
        Class erasedType = returnType.getErasedType();
        String className = erasedType.getSimpleName();
        boolean exist = vendorExtensions.stream().anyMatch(p -> Objects.equals(p.getName(), className));
        if (!exist) {
            List memberFields = returnType.getMemberFields();
            HashMap<String, Map> fieldProperties = new HashMap<String, Map>(16);
            for (RawField memberField : memberFields) {
                ApiModelProperty apiModelProperty;
                String key = memberField.getName();
                Length length = (Length)AnnotationUtils.findAnnotation((AnnotatedElement)memberField.getRawMember(), Length.class);
                if (length != null) {
                    Map properties = fieldProperties.computeIfAbsent(key, k -> new HashMap(16));
                    properties.computeIfAbsent("maxLength", k -> length.max());
                    properties.computeIfAbsent("minLength", k -> length.max());
                }
                if ((apiModelProperty = (ApiModelProperty)AnnotationUtils.findAnnotation((AnnotatedElement)memberField.getRawMember(), ApiModelProperty.class)) == null) continue;
                Map properties = fieldProperties.computeIfAbsent(key, k -> new HashMap(16));
                boolean required = apiModelProperty.required();
                if (!required) continue;
                properties.put("required", required);
            }
            vendorExtensions.add(new StringVendorExtension(className, JSON.toJSONString(fieldProperties)));
        }
    }

    private Class<?> getGenericType(Field curField) {
        Type genericType = curField.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getActualTypeArguments()[0];
        }
        return null;
    }

    private void setBizCode(Open open, List<VendorExtension> vendorExtensions) {
        BizCode[] bizCodes = open.bizCode();
        List codeObjList = Stream.of(bizCodes).map(bizCode -> new BizCodeObj(bizCode.code(), bizCode.msg(), bizCode.solution())).collect(Collectors.toList());
        vendorExtensions.add((VendorExtension)new StringVendorExtension(BIZ_CODE, JSON.toJSONString(codeObjList)));
    }

    private void setRequestDemo(String name, String requestDemo, List<VendorExtension> vendorExtensions) {
        if (StringUtils.isEmpty((CharSequence)requestDemo)) {
            requestDemo = "request.demo.java/" + name;
        }
        String demoStr = null;
        try {
            demoStr = FileUtil.getReadIoFile((String)requestDemo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        vendorExtensions.add((VendorExtension)new StringVendorExtension(REQUEST_DEMO, demoStr));
    }

    private String buildVersion(String version) {
        if ("".equals(version)) {
            return ServiceConfig.getInstance().getDefaultVersion();
        }
        return version;
    }

    private static class BizCodeObj {
        private String code;
        private String msg;
        private String solution;

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getSolution() {
            return this.solution;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setSolution(String solution) {
            this.solution = solution;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BizCodeObj)) {
                return false;
            }
            BizCodeObj other = (BizCodeObj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            String this$solution = this.getSolution();
            String other$solution = other.getSolution();
            return !(this$solution == null ? other$solution != null : !this$solution.equals(other$solution));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BizCodeObj;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            String $solution = this.getSolution();
            result = result * 59 + ($solution == null ? 43 : $solution.hashCode());
            return result;
        }

        public String toString() {
            return "DocumentationPluginsManagerExt.BizCodeObj(code=" + this.getCode() + ", msg=" + this.getMsg() + ", solution=" + this.getSolution() + ")";
        }

        public BizCodeObj(String code, String msg, String solution) {
            this.code = code;
            this.msg = msg;
            this.solution = solution;
        }
    }
}

