/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.result;

import com.alibaba.fastjson.annotation.JSONField;
import com.icetech.web.exception.ServiceException;
import com.icetech.web.message.ServiceError;
import com.icetech.web.message.ServiceErrorEnum;
import com.icetech.web.message.ServiceErrorMeta;
import com.icetech.web.result.ServiceResultBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceResultBuilder
implements ServiceResultBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceResultBuilder.class);

    @Override
    public Object buildError(HttpServletRequest request, HttpServletResponse response, Throwable throwable) {
        ServiceError error;
        if (throwable instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)throwable;
            error = serviceException.getError();
        } else {
            ServiceErrorMeta errorMeta = ServiceErrorEnum.ISP_UNKNOWN_ERROR.getErrorMeta();
            error = errorMeta.getError();
        }
        return this.buildError(error.getSub_code(), error.getSub_msg());
    }

    @Override
    public Object buildError(String subCode, String subMsg) {
        ErrorResult result = new ErrorResult();
        result.setSub_code(subCode);
        result.setSub_msg(subMsg);
        return result;
    }

    public static class ErrorResult {
        @JSONField(ordinal=1)
        private String sub_code;
        @JSONField(ordinal=2)
        private String sub_msg;

        public String getSub_code() {
            return this.sub_code;
        }

        public String getSub_msg() {
            return this.sub_msg;
        }

        public void setSub_code(String sub_code) {
            this.sub_code = sub_code;
        }

        public void setSub_msg(String sub_msg) {
            this.sub_msg = sub_msg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorResult)) {
                return false;
            }
            ErrorResult other = (ErrorResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sub_code = this.getSub_code();
            String other$sub_code = other.getSub_code();
            if (this$sub_code == null ? other$sub_code != null : !this$sub_code.equals(other$sub_code)) {
                return false;
            }
            String this$sub_msg = this.getSub_msg();
            String other$sub_msg = other.getSub_msg();
            return !(this$sub_msg == null ? other$sub_msg != null : !this$sub_msg.equals(other$sub_msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sub_code = this.getSub_code();
            result = result * 59 + ($sub_code == null ? 43 : $sub_code.hashCode());
            String $sub_msg = this.getSub_msg();
            result = result * 59 + ($sub_msg == null ? 43 : $sub_msg.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultServiceResultBuilder.ErrorResult(sub_code=" + this.getSub_code() + ", sub_msg=" + this.getSub_msg() + ")";
        }
    }
}

