/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.exception;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.exception.base.BaseException;
import com.icetech.common.utils.HttpTools;
import java.nio.file.AccessDeniedException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.text.ParseException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ObjectResponse<Void> httpMediaTypeNotSupportedException(HttpServletRequest request, HttpMediaTypeNotSupportedException e) {
        log.warn("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u5185\u5bb9|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getContentType()});
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_403);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ObjectResponse<Void> httpRequestMethodNotSupportedException(HttpServletRequest request, HttpRequestMethodNotSupportedException e) {
        log.warn("\u4e0d\u652f\u6301\u7684HTTP\u8bf7\u6c42\u65b9\u5f0f|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getMethod()});
        return ObjectResponse.failed((String)"403", (String)"\u4e0d\u652f\u6301\u7684HTTP\u8bf7\u6c42\u65b9\u5f0f");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ObjectResponse<String> handleMissingServletRequestParameterException(HttpServletRequest request, MissingServletRequestParameterException e) {
        log.warn("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getParameterName()});
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ObjectResponse<Void> methodArgumentTypeMismatchException(HttpServletRequest request, MethodArgumentTypeMismatchException e) {
        log.warn("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u6709\u8bef|{}|{}|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getParameter().getParameterName(), e.getParameter().getParameterType(), e.getRequiredType()});
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ObjectResponse<Void> methodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        String message = e.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(","));
        log.warn("\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), message});
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)message);
    }

    @ExceptionHandler(value={BindException.class})
    public ObjectResponse<Void> bindException(HttpServletRequest request, BindException e) {
        String message = e.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(","));
        log.warn("\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), message});
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)message);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ObjectResponse<String> constraintViolationException(HttpServletRequest request, ConstraintViolationException e) {
        String message = e.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","));
        log.warn("\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), message});
        return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_400.getCode(), (String)message);
    }

    @ExceptionHandler(value={MismatchedInputException.class})
    public ObjectResponse<Void> mismatchedInputException(HttpServletRequest request, MismatchedInputException e) {
        log.warn("\u8bf7\u6c42\u5185\u5bb9\u4e22\u5931|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getMessage()});
        return ObjectResponse.failed((String)"400", (String)"\u8bf7\u6c42\u5185\u5bb9\u65e0\u6548");
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ObjectResponse<String> httpMessageNotReadableException(HttpServletRequest request, HttpMessageNotReadableException e) {
        int index;
        String message = e.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message) && (index = message.indexOf(":")) > 0) {
            message = message.substring(0, index);
        }
        log.warn("\u8bf7\u6c42\u5185\u5bb9\u4e0d\u5168|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), message});
        return ObjectResponse.failed((String)"400", (String)"\u8bf7\u6c42\u5185\u5bb9\u4e0d\u5168");
    }

    @ExceptionHandler(value={ParseException.class})
    public ObjectResponse<String> handleParseException(HttpServletRequest request, ParseException e) {
        log.warn("\u53c2\u6570\u8f6c\u6362\u5931\u8d25|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getMessage()});
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ObjectResponse<Void> accessDeniedException(HttpServletRequest request, AccessDeniedException e) {
        log.warn("\u8bf7\u6c42\u65e0\u6743\u8bbf\u95ee|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getMessage()});
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_401);
    }

    @ExceptionHandler(value={ResponseBodyException.class})
    public ObjectResponse<Void> responseBodyException(HttpServletRequest request, ResponseBodyException e) {
        log.warn("\u4e1a\u52a1\u5904\u7406\u5f02\u5e38|{}|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getErrCode(), e.getMessage()});
        return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BaseException.class})
    public ObjectResponse<Object> baseException(BaseException e) {
        log.warn("base\u5f02\u5e38|{}|{}|{}", new Object[]{e.getMessage(), e.getCode(), e.getArgs()});
        return ObjectResponse.failed((String)e.getCode(), (Object[])e.getArgs());
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class})
    public ObjectResponse<Void> sqlIntegrityConstraintViolationException(HttpServletRequest request, SQLException e) {
        log.error("SQL\u6267\u884c\u5f02\u5e38|{}|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e.getErrorCode(), e});
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_405);
    }

    @ExceptionHandler(value={Exception.class})
    public ObjectResponse<Void> exception(HttpServletRequest request, Exception e) {
        log.error("\u8bf7\u6c42\u5904\u7406\u5f02\u5e38|{}|{}", new Object[]{request.getRequestURI(), HttpTools.getIpAddr((HttpServletRequest)request), e});
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
    }
}

