/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.filter;

import com.icetech.common.constants.CommonConstants;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.common.utils.StringUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TraceFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Object traceIdObj;
            String traceId;
            String string = traceId = request instanceof HttpServletRequest ? ((HttpServletRequest)request).getHeader(CommonConstants.TRACE_ID_KEY) : null;
            if (StringUtils.isBlank((CharSequence)traceId) && (traceIdObj = request.getAttribute(CommonConstants.TRACE_ID_KEY)) != null) {
                traceId = traceIdObj.toString();
            }
            traceId = StringUtils.isBlank((CharSequence)traceId) ? Slf4jUtils.putTraceId() : Slf4jUtils.putTraceId((String)traceId);
            request.setAttribute(CommonConstants.TRACE_ID_KEY, (Object)traceId);
            chain.doFilter(request, response);
        }
        finally {
            Slf4jUtils.removeTraceId();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("[TraceFilter \u521d\u59cb\u5316\u5b8c\u6210]");
    }

    public void destroy() {
        log.info("[TraceFilter \u9500\u6bc1]");
    }
}

