/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.filter;

import com.alibaba.fastjson.JSON;
import com.icetech.common.utils.HttpTools;
import com.icetech.web.wrapper.HttpServletRequestDecorator;
import com.icetech.web.wrapper.HttpServletResponseDecorator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.AntPathMatcher;

public class LoggingHttpFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LoggingHttpFilter.class);
    @Value(value="${ice.web.filter.logging-http.trunc-length:2048}")
    private int truncLength;
    @Value(value="#{'${ice.web.filter.logging-http.ignore-path:}'.split(',')}")
    private String[] ignorePaths;
    private static final Pattern PATTERN_FORM_FILE_NAME = Pattern.compile("filename=\"([^\\f\\n\\r\\t\\v\"]+)\"");
    private static final byte[] SUFFIX_TRUNC = " ......".getBytes(StandardCharsets.UTF_8);
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (this.ignorePaths != null && this.ignorePaths.length > 0) {
                for (int i = 0; i < this.ignorePaths.length; ++i) {
                    String ignorePath = this.ignorePaths[i];
                    if (!PATH_MATCHER.match(ignorePath, httpServletRequest.getRequestURI())) continue;
                    chain.doFilter(request, response);
                    return;
                }
            }
        }
        long begin = System.currentTimeMillis();
        String requestURI = "";
        String requestAddr = "";
        try {
            HttpServletRequestDecorator requestWrapper = null;
            if (request instanceof HttpServletRequestDecorator) {
                requestWrapper = (HttpServletRequestDecorator)((Object)request);
            } else if (request instanceof HttpServletRequest) {
                requestWrapper = new HttpServletRequestDecorator((HttpServletRequest)request);
                request = requestWrapper;
            }
            if (requestWrapper != null) {
                requestURI = requestWrapper.getRequestURI();
                requestAddr = HttpTools.getIpAddr((HttpServletRequest)((HttpServletRequest)request));
                byte[] requestBytes = this.truncBytes(requestWrapper.getCacheBody());
                String requestBody = new String(requestBytes, StringUtils.isBlank((CharSequence)requestWrapper.getCharacterEncoding()) ? StandardCharsets.UTF_8 : Charset.forName(requestWrapper.getCharacterEncoding()));
                String content = requestURI + "|" + requestAddr + "|" + requestWrapper.getMethod() + "|" + requestWrapper.getDispatcherType() + "|" + requestWrapper.getContentType() + "|" + this.buildParameterLog((HttpServletRequest)requestWrapper) + "|" + this.buildPartLog((HttpServletRequest)requestWrapper);
                log.info(content + "|" + requestBody);
            }
            if (response instanceof HttpServletResponse && !(response instanceof HttpServletResponseDecorator)) {
                response = new HttpServletResponseDecorator((HttpServletResponse)response);
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            try {
                log.error("\u65e5\u5fd7\u8bb0\u5f55\u5668\u51fa\u9519|{}|{}|{}ms", new Object[]{requestURI, System.currentTimeMillis() - begin, e});
            }
            catch (Throwable throwable) {
                if (response instanceof HttpServletResponseDecorator) {
                    HttpServletResponseDecorator responseWrapper = (HttpServletResponseDecorator)((Object)response);
                    String disposition = responseWrapper.getHeader("Content-Disposition");
                    String responseBody = null;
                    if (StringUtils.startsWith((CharSequence)disposition, (CharSequence)"attachment;filename=")) {
                        disposition = disposition.replaceFirst("attachment;filename=", "");
                        responseBody = "FILE:" + disposition;
                    } else {
                        byte[] responseBytes = this.truncBytes(responseWrapper.getContentAsByteArray());
                        responseBody = new String(responseBytes, StandardCharsets.UTF_8);
                    }
                    log.info("{}|{}|{}|{}ms", new Object[]{requestURI, responseWrapper.getContentType(), responseBody, System.currentTimeMillis() - begin});
                }
                throw throwable;
            }
            if (response instanceof HttpServletResponseDecorator) {
                HttpServletResponseDecorator responseWrapper = (HttpServletResponseDecorator)((Object)response);
                String disposition = responseWrapper.getHeader("Content-Disposition");
                String responseBody = null;
                if (StringUtils.startsWith((CharSequence)disposition, (CharSequence)"attachment;filename=")) {
                    disposition = disposition.replaceFirst("attachment;filename=", "");
                    responseBody = "FILE:" + disposition;
                } else {
                    byte[] responseBytes = this.truncBytes(responseWrapper.getContentAsByteArray());
                    responseBody = new String(responseBytes, StandardCharsets.UTF_8);
                }
                log.info("{}|{}|{}|{}ms", new Object[]{requestURI, responseWrapper.getContentType(), responseBody, System.currentTimeMillis() - begin});
            }
        }
        if (response instanceof HttpServletResponseDecorator) {
            HttpServletResponseDecorator responseWrapper = (HttpServletResponseDecorator)((Object)response);
            String disposition = responseWrapper.getHeader("Content-Disposition");
            String responseBody = null;
            if (StringUtils.startsWith((CharSequence)disposition, (CharSequence)"attachment;filename=")) {
                disposition = disposition.replaceFirst("attachment;filename=", "");
                responseBody = "FILE:" + disposition;
            } else {
                byte[] responseBytes = this.truncBytes(responseWrapper.getContentAsByteArray());
                responseBody = new String(responseBytes, StandardCharsets.UTF_8);
            }
            log.info("{}|{}|{}|{}ms", new Object[]{requestURI, responseWrapper.getContentType(), responseBody, System.currentTimeMillis() - begin});
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("LoggingFilter \u521d\u59cb\u5316");
        log.info("\u8bbe\u5b9a\u65e5\u5fd7\u5b57\u7b26\u4e32\u6700\u5927\u8f93\u51fa\u957f\u5ea6\u4e3a: {}", (Object)this.truncLength);
        log.info("\u8bbe\u5b9a\u5ffd\u7565\u65e5\u5fd7\u8bb0\u5f55\u8def\u5f84: {}", (Object)Arrays.toString(this.ignorePaths));
    }

    public void destroy() {
        log.info("LoggingFilter \u9500\u6bc1");
    }

    private String buildQueryLog(HttpServletRequest request) {
        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty()) {
            return "[query:" + request.getQueryString() + "]";
        }
        return "";
    }

    private String buildParameterLog(HttpServletRequest request) {
        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty()) {
            return "[parameter:" + JSON.toJSONString((Object)request.getParameterMap()) + "]";
        }
        return "";
    }

    private String buildPartLog(HttpServletRequest request) throws IOException, ServletException {
        String contentType = request.getContentType();
        if (StringUtils.containsAny((CharSequence)contentType, (CharSequence[])new CharSequence[]{"multipart/form-data", "multipart/mixed"}) && request.getParts() != null && !request.getParts().isEmpty()) {
            List parts = request.getParts().stream().map(part -> {
                String disposition = part.getHeader("Content-Disposition");
                Matcher matcher = PATTERN_FORM_FILE_NAME.matcher(disposition);
                if (matcher.find()) {
                    String fileName = matcher.group(1);
                    return part.getName() + "=" + fileName + ":" + part.getSize();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return "[part:" + JSON.toJSONString(parts) + "]";
        }
        return "";
    }

    private byte[] truncBytes(byte[] source) {
        int maxLength = this.truncLength + SUFFIX_TRUNC.length;
        if (source.length > maxLength) {
            byte[] truncated = new byte[maxLength];
            System.arraycopy(source, 0, truncated, 0, this.truncLength);
            System.arraycopy(SUFFIX_TRUNC, 0, truncated, this.truncLength, SUFFIX_TRUNC.length);
            return truncated;
        }
        return source;
    }
}

