/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.aop;

import com.icetech.common.utils.StringUtils;
import com.icetech.web.bean.ParamNames;
import com.icetech.web.exception.ExceptionHolder;
import com.icetech.web.utils.ServletUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@ConditionalOnClass(value={HttpServletRequest.class, RequestContextHolder.class})
public class GatewayExceptionAspect {
    private static final Logger log = LoggerFactory.getLogger(GatewayExceptionAspect.class);

    @AfterReturning(pointcut="@annotation(exceptionHandler)")
    public void beforeMethod(JoinPoint joinPoint, ExceptionHandler exceptionHandler) {
        if (StringUtils.isEmpty((CharSequence)Objects.requireNonNull(ServletUtils.getRequest()).getHeader(ParamNames.HEADER_VERSION_NAME))) {
            return;
        }
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        Optional<Object> first = Arrays.stream(args).filter(t -> t instanceof Throwable).findFirst();
        if (!first.isPresent()) {
            return;
        }
        ExceptionHolder.hold(ServletUtils.getRequest(), Objects.requireNonNull(ServletUtils.getResponse()), (Exception)first.get());
    }
}

