package com.icetech.web.filter;

import java.io.IOException;

import com.icetech.web.wrapper.HttpServletRequestDecorator;
import com.icetech.web.wrapper.HttpServletResponseDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Description: filter implements
 * All Rights Reserved.
 *
 * @version 1.0  wgy
 */
@Order(0)
public class WrapperServletRequestFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(WrapperServletRequestFilter.class);

    public WrapperServletRequestFilter() {
    }

    @Override
    public void init(FilterConfig filterConfig) {
        logger.info("Init web filter...");

        logger.info("Init web filter success!");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("webFilter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        HttpServletResponse httpResponse = (HttpServletResponse) response;
        try {
            //设置请求的编码
            //// 使用spring等的编码filter处理
            //对请求进行包装
            httpRequest = wrapRequest(httpRequest);
            //对应答进行包装
            HttpServletResponseDecorator respDecorator = wrapResponse(httpResponse);
            //将请求和应答交给下一个处理器处理
            filterChain.doFilter(httpRequest, respDecorator);
            // 将response缓存的响应信息写入响应流(必须)
            respDecorator.copyBodyToResponse();
        } catch (Exception e) {
            logger.error("ApiWebFilter error", e);
        }
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) throws IOException {
        if (!(request instanceof HttpServletRequestDecorator)) {
            return new HttpServletRequestDecorator(request);
        }
        return request;
    }

    private HttpServletResponseDecorator wrapResponse(HttpServletResponse response) {
        if (!(response instanceof HttpServletResponseDecorator)) {
            return new HttpServletResponseDecorator(response);
        }
        return (HttpServletResponseDecorator) response;
    }

    @Override
    public void destroy() {
        logger.info("Destroy web filter success!");
    }

}
