/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.icetech.web.aop.anno.Open;
import com.icetech.web.bean.OpenContextImpl;
import com.icetech.web.bean.ServiceContext;
import com.icetech.web.utils.OpenUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ServiceContextInterceptor
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ServiceContext context = ServiceContext.getCurrentContext();
        context.setRequest(request);
        context.setResponse(response);
        this.initOpenContextWithNoParam(context, request, handler);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ServiceContext.getCurrentContext().unset();
    }

    private void initOpenContextWithNoParam(ServiceContext context, HttpServletRequest request, Object handler) {
        HandlerMethod handlerMethod;
        Open open;
        if (handler instanceof HandlerMethod && (open = (Open)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(Open.class)) != null) {
            JSONObject requestParams = OpenUtil.getRequestParams(request);
            OpenContextImpl openContext = new OpenContextImpl(requestParams);
            context.setOpenContext(openContext);
        }
    }
}

