/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.configuration;

import com.icetech.web.aop.ControllerLogAspect;
import com.icetech.web.exception.GlobalExceptionHandler;
import com.icetech.web.exception.ICustomizeExceptionAdvice;
import com.icetech.web.filter.LoggingHttpFilter;
import com.icetech.web.filter.SaTokenFilter;
import com.icetech.web.filter.TraceFilter;
import com.icetech.web.filter.WrapperServletRequestFilter;
import com.icetech.web.message.I18nLocaleResolver;
import com.icetech.web.route.RequestMappingScan;
import com.icetech.web.swagger.SwaggerDocRun;
import java.util.Collections;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;
import springfox.documentation.spring.web.DocumentationCache;

@Configuration
public class IceWebConfiguration {
    @ConditionalOnMissingBean(value={WrapperServletRequestFilter.class})
    @Bean
    public FilterRegistrationBean<WrapperServletRequestFilter> apiFilterRegistrationBean() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new WrapperServletRequestFilter());
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setOrder(0);
        return bean;
    }

    @ConditionalOnMissingBean(value={GlobalExceptionHandler.class, ICustomizeExceptionAdvice.class})
    @ConditionalOnClass(value={ServletException.class})
    @Bean
    public GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="ice.web.aop.controller-log", name={"enable"}, havingValue="true", matchIfMissing=false)
    public ControllerLogAspect controllerLogAspect() {
        return new ControllerLogAspect();
    }

    @Bean
    @ConditionalOnProperty(prefix="ice.web.filter.logging-trace", name={"enable"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<TraceFilter> traceFilterBean() {
        TraceFilter filter = new TraceFilter();
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        bean.setOrder(Integer.MIN_VALUE);
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setDispatcherTypes(EnumSet.allOf(DispatcherType.class));
        return bean;
    }

    @Bean
    @ConditionalOnProperty(prefix="ice.web.filter.logging-http", name={"enable"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<LoggingHttpFilter> loggingHttpFilterBean() {
        LoggingHttpFilter filter = this.loggingHttpFilter();
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        bean.setOrder(this.apiFilterRegistrationBean().getOrder() + 1);
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setDispatcherTypes(EnumSet.allOf(DispatcherType.class));
        return bean;
    }

    @Bean
    @ConditionalOnProperty(prefix="ice.web.filter.logging-http", name={"enable"}, havingValue="true", matchIfMissing=true)
    public LoggingHttpFilter loggingHttpFilter() {
        return new LoggingHttpFilter();
    }

    @Bean
    @ConditionalOnClass(name={"com.icetech.token.utils.LoginHelper"})
    public SaTokenFilter saTokenFilter() {
        return new SaTokenFilter();
    }

    @Bean
    @ConditionalOnClass(name={"com.icetech.mq.sender.RabbitSender"})
    @ConditionalOnProperty(value={"ice.route.scan"})
    public RequestMappingScan resourceAnnotationScan() {
        return new RequestMappingScan();
    }

    @Bean
    @ConditionalOnClass(name={"com.icetech.mq.sender.RabbitSender"})
    @ConditionalOnProperty(value={"ice.route.scan"})
    @ConditionalOnBean(value={DocumentationCache.class})
    public SwaggerDocRun swaggerDocRun() {
        return new SwaggerDocRun();
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new I18nLocaleResolver();
    }
}

