/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.configuration;

import com.icetech.web.bean.ServiceConfig;
import com.icetech.web.interceptor.ServiceContextInterceptor;
import com.icetech.web.message.ServiceErrorFactory;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class DefaultMvcConfiguration
implements WebMvcConfigurer,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultMvcConfiguration.class);
    public static final String ICE_ROUTE_SCAN = "ice.route.scan";

    public DefaultMvcConfiguration() {
        ServiceConfig.getInstance().getI18nModules().add("i18n/isp/bizerror");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!(converter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)converter).setDefaultCharset(StandardCharsets.UTF_8);
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ServiceContextInterceptor());
    }

    @PostConstruct
    public final void after() {
        log.info("-----spring\u5bb9\u5668\u52a0\u8f7d\u5b8c\u6bd5-----");
        this.initMessage();
        this.doAfter();
    }

    protected void doAfter() {
    }

    protected void initMessage() {
        ServiceErrorFactory.initMessageSource(ServiceConfig.getInstance().getI18nModules());
    }

    static {
        ServiceConfig.getInstance().setDefaultVersion("1.0");
    }
}

