package com.icetech.web.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.springframework.util.StreamUtils;

public class ContentCacheRequestWrapper extends HttpServletRequestWrapper {
    protected HttpServletRequest request;
    protected byte[] cacheContent;
    protected ServletInputStream inputStream;
    protected BufferedReader reader;

    public ContentCacheRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.request = request;
        request.getParameterMap();  // 读取body后parameterMap不再初始化
        cacheContent = StreamUtils.copyToByteArray(request.getInputStream());
        inputStream = new RequestCachingInputStream(cacheContent);
    }

    @Override
    public String getParameter(String name) {
        return super.getParameter(name);
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return inputStream;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (reader == null) {
            reader = new BufferedReader(new InputStreamReader(inputStream, getCharacterEncoding()));
        }
        return reader;
    }

    public byte[] getCacheContent() {
        return cacheContent;
    }

    public void reset() throws IOException {
        inputStream.close();
        inputStream = new RequestCachingInputStream(cacheContent);
    }

    private static class RequestCachingInputStream extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public RequestCachingInputStream(byte[] bytes) {
            inputStream = new ByteArrayInputStream(bytes);
        }

        @Override
        public int read() throws IOException {
            return inputStream.read();
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public boolean isFinished() {
            return inputStream.available() == 0;
        }

        @Override
        public void setReadListener(ReadListener listener) {

        }
    }
}
