package com.icetech.web.bean;

import com.icetech.web.result.DefaultServiceResultBuilder;
import com.icetech.web.result.ServiceResultBuilder;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wgy
 */
@Data
public class ServiceConfig {

    private static ServiceConfig instance = new ServiceConfig();

    private ServiceConfig() {
    }

    public static ServiceConfig getInstance() {
        return instance;
    }

    public static void setInstance(ServiceConfig instance) {
        ServiceConfig.instance = instance;
    }

    /**
     * 错误模块
     */
    private List<String> i18nModules = new ArrayList<>();

    /**
     * 返回结果处理
     */
    private ServiceResultBuilder serviceResultBuilder = new DefaultServiceResultBuilder();

    /**
     * 默认版本号
     */
    private String defaultVersion = "";

    /**
     * 设置为true，所有接口不进行校验
     */
    private boolean ignoreValidate;

    /**
     * 是否需要授权才能访问
     */
    private boolean permission;


}
