package com.icetech.web.bean;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description OperatorLogMsg
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/3/24 13:49
 */
@Data
public class OperatorLogMsg implements Serializable {
    /**
     * 平台类型 open:开放平台, device:设备运维平台, park: 场库服务
     */
    private String platformType;

    /**
     * 模块标题
     */
    private String title;

    /**
     * 业务类型（0其它 1新增 2修改 3删除）
     */
    private Integer businessType;

    /**
     * 方法名称
     */
    private String methodName;

    /**
     * 请求方式
     */
    private String requestMethod;

    /**
     * 操作类别（0其它 1后台用户 2手机端用户）
     */
    private Integer operatorType;

    /**
     * 操作人Id
     */
    private Long userId;

    /**
     * 操作人员
     */
    private String username;

    /**
     * 请求URL
     */
    private String url;

    /**
     * 主机地址
     */
    private String ip;

    /**
     * 操作地点
     */
    private String location;

    /**
     * 操作信息
     */
    private String operationMsg;

    /**
     * 请求参数
     */
    private String param;

    /**
     * 返回参数
     */
    private String jsonResult;

    /**
     * 操作状态（1正常 0异常）
     */
    private Integer status;

    /**
     * 错误消息
     */
    private String errorMsg;

    /**
     * 操作时间
     */
    private Date operationTime;
}
