package com.icetech.web.aop;

import com.icetech.common.utils.StringUtils;
import com.icetech.web.bean.ParamNames;
import com.icetech.web.exception.ExceptionHolder;
import com.icetech.web.utils.ServletUtils;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * Description 拦截器异常处理
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/25 7:27 下午
 */
@Slf4j
@Aspect
@ConditionalOnClass({HttpServletRequest.class, RequestContextHolder.class})
public class GatewayExceptionAspect {

    @AfterReturning(pointcut = "@annotation(exceptionHandler)")
    public void beforeMethod(JoinPoint joinPoint, ExceptionHandler exceptionHandler) {
        // 判断是否未网关请求
        if (StringUtils.isEmpty(Objects.requireNonNull(ServletUtils.getRequest()).getHeader(ParamNames.HEADER_VERSION_NAME))) {
            return;
        }
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        Optional<Object> first = Arrays.stream(args).filter(t -> t instanceof Throwable).findFirst();
        if (!first.isPresent()) {
            return;
        }
        ExceptionHolder.hold(ServletUtils.getRequest(), Objects.requireNonNull(ServletUtils.getResponse()), (Exception) first.get());
    }

}
