/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.token.utils;

import cn.hutool.core.collection.IterUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.redisson.api.ObjectListener;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;

public class RedisUtils {
    private RedissonClient CLIENT;

    public RedisUtils(RedissonClient client) {
        this.CLIENT = client;
    }

    public long rateLimiter(String key, RateType rateType, int rate, int rateInterval) {
        RRateLimiter rateLimiter = this.CLIENT.getRateLimiter(key);
        rateLimiter.trySetRate(rateType, (long)rate, (long)rateInterval, RateIntervalUnit.SECONDS);
        if (rateLimiter.tryAcquire()) {
            return rateLimiter.availablePermits();
        }
        return -1L;
    }

    public <T> void publish(String channelKey, T msg, Consumer<T> consumer) {
        RTopic topic = this.CLIENT.getTopic(channelKey);
        topic.publish(msg);
        consumer.accept(msg);
    }

    public <T> void publish(String channelKey, T msg) {
        RTopic topic = this.CLIENT.getTopic(channelKey);
        topic.publish(msg);
    }

    public <T> void subscribe(String channelKey, Class<T> clazz, Consumer<T> consumer) {
        RTopic topic = this.CLIENT.getTopic(channelKey);
        topic.addListener(clazz, (channel, msg) -> consumer.accept(msg));
    }

    public <T> void setCacheObject(String key, T value) {
        this.setCacheObject(key, value, false);
    }

    public <T> void setCacheObject(String key, T value, boolean isSaveTtl) {
        RBucket bucket = this.CLIENT.getBucket(key);
        if (isSaveTtl) {
            try {
                bucket.setAndKeepTTL(value);
            }
            catch (Exception e) {
                long timeToLive = bucket.remainTimeToLive();
                bucket.set(value);
                bucket.expire(timeToLive, TimeUnit.MILLISECONDS);
            }
        } else {
            bucket.set(value);
        }
    }

    public <T> void setCacheObject(String key, T value, long timeout, TimeUnit timeUnit) {
        RBucket result = this.CLIENT.getBucket(key);
        result.set(value);
        result.expire(timeout, timeUnit);
    }

    public <T> void addObjectListener(String key, ObjectListener listener) {
        RBucket result = this.CLIENT.getBucket(key);
        result.addListener(listener);
    }

    public boolean expire(String key, long timeout) {
        return this.expire(key, timeout, TimeUnit.SECONDS);
    }

    public boolean expire(String key, long timeout, TimeUnit unit) {
        RBucket rBucket = this.CLIENT.getBucket(key);
        return rBucket.expire(timeout, unit);
    }

    public <T> T getCacheObject(String key) {
        RBucket rBucket = this.CLIENT.getBucket(key);
        return (T)rBucket.get();
    }

    public <T> long getTimeToLive(String key) {
        RBucket rBucket = this.CLIENT.getBucket(key);
        return rBucket.remainTimeToLive();
    }

    public boolean deleteObject(String key) {
        return this.CLIENT.getBucket(key).delete();
    }

    public void deleteObject(Collection collection) {
        RBatch batch = this.CLIENT.createBatch();
        collection.forEach(t -> batch.getBucket(t.toString()).deleteAsync());
        batch.execute();
    }

    public <T> boolean setCacheList(String key, List<T> dataList) {
        RList rList = this.CLIENT.getList(key);
        return rList.addAll(dataList);
    }

    public <T> void addListListener(String key, ObjectListener listener) {
        RList rList = this.CLIENT.getList(key);
        rList.addListener(listener);
    }

    public <T> List<T> getCacheList(String key) {
        RList rList = this.CLIENT.getList(key);
        return rList.readAll();
    }

    public <T> boolean setCacheSet(String key, Set<T> dataSet) {
        RSet rSet = this.CLIENT.getSet(key);
        return rSet.addAll(dataSet);
    }

    public <T> void addSetListener(String key, ObjectListener listener) {
        RSet rSet = this.CLIENT.getSet(key);
        rSet.addListener(listener);
    }

    public <T> Set<T> getCacheSet(String key) {
        RSet rSet = this.CLIENT.getSet(key);
        return rSet.readAll();
    }

    public <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            RMap rMap = this.CLIENT.getMap(key);
            rMap.putAll(dataMap);
        }
    }

    public <T> void addMapListener(String key, ObjectListener listener) {
        RMap rMap = this.CLIENT.getMap(key);
        rMap.addListener(listener);
    }

    public <T> Map<String, T> getCacheMap(String key) {
        RMap rMap = this.CLIENT.getMap(key);
        return rMap.getAll(rMap.keySet());
    }

    public <T> void setCacheMapValue(String key, String hKey, T value) {
        RMap rMap = this.CLIENT.getMap(key);
        rMap.put((Object)hKey, value);
    }

    public <T> T getCacheMapValue(String key, String hKey) {
        RMap rMap = this.CLIENT.getMap(key);
        return (T)rMap.get((Object)hKey);
    }

    public <T> T delCacheMapValue(String key, String hKey) {
        RMap rMap = this.CLIENT.getMap(key);
        return (T)rMap.remove((Object)hKey);
    }

    public <K, V> Map<K, V> getMultiCacheMapValue(String key, Set<K> hKeys) {
        RMap rMap = this.CLIENT.getMap(key);
        return rMap.getAll(hKeys);
    }

    public Collection<String> keys(String pattern) {
        Iterable iterable = this.CLIENT.getKeys().getKeysByPattern(pattern);
        return IterUtil.toList((Iterable)iterable);
    }

    public Boolean hasKey(String key) {
        RKeys rKeys = this.CLIENT.getKeys();
        return rKeys.countExists(new String[]{key}) > 0L;
    }

    public RedissonClient getCLIENT() {
        return this.CLIENT;
    }

    public void setCLIENT(RedissonClient CLIENT) {
        this.CLIENT = CLIENT;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisUtils)) {
            return false;
        }
        RedisUtils other = (RedisUtils)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedissonClient this$CLIENT = this.getCLIENT();
        RedissonClient other$CLIENT = other.getCLIENT();
        return !(this$CLIENT == null ? other$CLIENT != null : !this$CLIENT.equals(other$CLIENT));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedissonClient $CLIENT = this.getCLIENT();
        result = result * 59 + ($CLIENT == null ? 43 : $CLIENT.hashCode());
        return result;
    }

    public String toString() {
        return "RedisUtils(CLIENT=" + this.getCLIENT() + ")";
    }
}

