/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.token.config;

import com.icetech.redis.config.RedissonAutoConfigurationCustomizer;
import com.icetech.redis.config.RedissonProperties;
import com.icetech.token.core.dao.PlusSaTokenAloneRedisDao;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.ReflectionUtils;

@Configuration
public class SaAloneRedisInject
implements EnvironmentAware {
    public static final String ALONE_PREFIX = "sa-token.alone-redis";
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    @Autowired(required=false)
    public PlusSaTokenAloneRedisDao saTokenDao;
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private ApplicationContext ctx;
    @Autowired(required=false)
    private List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers;

    public void setEnvironment(Environment environment) {
        try {
            int timeout;
            if (this.saTokenDao == null) {
                return;
            }
            if (environment.getProperty("sa-token.alone-redis.host") == null) {
                return;
            }
            RedisProperties redisProperties = (RedisProperties)Binder.get((Environment)environment).bind(ALONE_PREFIX, RedisProperties.class).get();
            Config config = null;
            Method clusterMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getCluster");
            Method timeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getTimeout");
            Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)redisProperties);
            if (null == timeoutValue) {
                timeout = 10000;
            } else if (!(timeoutValue instanceof Integer)) {
                Method millisMethod = ReflectionUtils.findMethod(timeoutValue.getClass(), (String)"toMillis");
                timeout = ((Long)ReflectionUtils.invokeMethod((Method)millisMethod, (Object)timeoutValue)).intValue();
            } else {
                timeout = (Integer)timeoutValue;
            }
            if (this.redissonProperties.getConfig() != null) {
                try {
                    config = Config.fromYAML((String)this.redissonProperties.getConfig());
                }
                catch (IOException e) {
                    try {
                        config = Config.fromJSON((String)this.redissonProperties.getConfig());
                    }
                    catch (IOException e1) {
                        throw new IllegalArgumentException("Can't parse config", e1);
                    }
                }
            } else if (this.redissonProperties.getFile() != null) {
                try {
                    InputStream is = this.getConfigStream();
                    config = Config.fromYAML((InputStream)is);
                }
                catch (IOException e) {
                    try {
                        InputStream is = this.getConfigStream();
                        config = Config.fromJSON((InputStream)is);
                    }
                    catch (IOException e1) {
                        throw new IllegalArgumentException("Can't parse config", e1);
                    }
                }
            } else if (redisProperties.getSentinel() != null) {
                Method nodesMethod = ReflectionUtils.findMethod(RedisProperties.Sentinel.class, (String)"getNodes");
                Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)redisProperties.getSentinel());
                String[] nodes = nodesValue instanceof String ? this.convert(Arrays.asList(((String)nodesValue).split(","))) : this.convert((List)nodesValue);
                config = new Config();
                ((SentinelServersConfig)config.useSentinelServers().setMasterName(redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(redisProperties.getDatabase()).setConnectTimeout(timeout)).setPassword(redisProperties.getPassword());
            } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)redisProperties) != null) {
                Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)redisProperties);
                Method nodesMethod = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
                List nodesObject = (List)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)clusterObject);
                String[] nodes = this.convert(nodesObject);
                config = new Config();
                ((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setPassword(redisProperties.getPassword());
            } else {
                config = new Config();
                String prefix = REDIS_PROTOCOL_PREFIX;
                Method method = ReflectionUtils.findMethod(RedisProperties.class, (String)"isSsl");
                if (method != null && ((Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)redisProperties)).booleanValue()) {
                    prefix = REDISS_PROTOCOL_PREFIX;
                }
                ((SingleServerConfig)config.useSingleServer().setAddress(prefix + redisProperties.getHost() + ":" + redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(redisProperties.getDatabase()).setPassword(redisProperties.getPassword());
            }
            if (this.redissonAutoConfigurationCustomizers != null) {
                for (RedissonAutoConfigurationCustomizer customizer : this.redissonAutoConfigurationCustomizers) {
                    customizer.customize(config);
                }
            }
            config.setCodec((Codec)JsonJacksonCodec.INSTANCE);
            this.saTokenDao.init(Redisson.create((Config)config));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ConfigurationProperties(prefix="sa-token.alone-redis")
    public RedisProperties getSaAloneRedisConfig() {
        return new RedisProperties();
    }

    private InputStream getConfigStream() throws IOException {
        Resource resource = this.ctx.getResource(this.redissonProperties.getFile());
        InputStream is = resource.getInputStream();
        return is;
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith(REDIS_PROTOCOL_PREFIX) && !node.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(REDIS_PROTOCOL_PREFIX + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[nodes.size()]);
    }
}

