/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rpc.trace;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson2.JSON;
import com.icetech.common.annotation.LogIgnore;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CommonConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.i18n.LocaleContextHolder;

@Activate(group={"provider", "consumer"}, order=-3000, value={"traceIdFilter"})
public class TraceIdFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TraceIdFilter.class);
    Snowflake snowflake = new Snowflake(1L, 0L);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String contextType;
        Method invokeMethod;
        if (!invoker.getInterface().getName().startsWith("com.icetech.")) {
            log.warn("dubbo\u8fc7\u6ee4\u5668|\u975e\u81ea\u6709\u63a5\u53e3|{}", (Object)invoker.getInterface().getName());
            return invoker.invoke(invocation);
        }
        RpcServiceContext rpcContext = RpcContext.getCurrentServiceContext();
        if (rpcContext.isProviderSide()) {
            String traceId = rpcContext.getAttachment(CommonConstants.TRACE_ID_KEY);
            if (traceId == null) {
                traceId = this.snowflake.nextIdStr();
            }
            MDC.put((String)CommonConstants.TRACE_ID_KEY, (String)traceId);
            Locale locale = (Locale)rpcContext.getObjectAttachment(CommonConstants.LOCALE_KEY);
            if (Objects.nonNull(locale)) {
                LocaleContextHolder.setLocale((Locale)locale);
            }
        } else {
            String traceId = MDC.get((String)CommonConstants.TRACE_ID_KEY);
            if (traceId == null) {
                traceId = this.snowflake.nextIdStr();
            }
            rpcContext.setAttachment(CommonConstants.TRACE_ID_KEY, traceId);
            rpcContext.setObjectAttachment(CommonConstants.LOCALE_KEY, (Object)LocaleContextHolder.getLocale());
        }
        try {
            invokeMethod = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
        }
        catch (Exception e) {
            log.error("[dubbo\u8fc7\u6ee4\u5668]\u627e\u4e0d\u5230\u5bf9\u5e94\u63a5\u53e3\u65b9\u6cd5: {}.{}({})", new Object[]{invoker.getInterface().getName(), invocation.getMethodName(), Arrays.toString(invocation.getParameterTypes()), e});
            throw new RpcException((Throwable)e);
        }
        LogIgnore annotation = invokeMethod.getAnnotation(LogIgnore.class);
        URL targetUrl = invoker.getUrl();
        String address = targetUrl.getAddress();
        String[] interfaces = invoker.getUrl().getParameter("interface").split("\\.");
        String interfaceName = (interfaces.length > 0 ? interfaces[interfaces.length - 1] : "") + "." + invocation.getMethodName();
        String string = contextType = rpcContext.isConsumerSide() ? "client" : "server";
        if (Objects.isNull(annotation)) {
            String param = JSON.toJSONString((Object)invocation.getArguments());
            log.info("[{}][{}|{}]receive:{}", new Object[]{contextType, address, interfaceName, StringUtils.isNotEmpty((CharSequence)param) && param.length() > 512 ? param.substring(0, 512) + "......" : param});
        }
        try {
            long beginTime = System.currentTimeMillis();
            Result result = invoker.invoke(invocation);
            if (Objects.nonNull(annotation)) {
                Result result2 = result;
                return result2;
            }
            long endTime = System.currentTimeMillis();
            if (result.hasException()) {
                Throwable throwable = result.getException();
                if (invokeMethod.getReturnType() != ObjectResponse.class) {
                    throw new RpcException(throwable);
                }
                ObjectResponse response = new ObjectResponse();
                if (throwable instanceof ResponseBodyException) {
                    ResponseBodyException exception = (ResponseBodyException)throwable;
                    log.error("[dubbo\u8fc7\u6ee4\u5668]\u8c03\u7528[{}|{}.{}({})]\u51fa\u9519: {}.{}. Arguments[{}]", new Object[]{address, invoker.getInterface().getName(), invocation.getMethodName(), Arrays.toString(invocation.getParameterTypes()), exception.getErrCode(), exception.getMessage(), Arrays.toString(invocation.getArguments()), exception});
                    response.setCode(exception.getErrCode());
                    response.setMsg(exception.getMessage());
                } else {
                    log.error("[dubbo\u8fc7\u6ee4\u5668]\u8c03\u7528[{}|{}.{}({})]\u51fa\u9519: {}. Arguments[{}]", new Object[]{address, invoker.getInterface().getName(), invocation.getMethodName(), Arrays.toString(invocation.getParameterTypes()), throwable.getMessage(), Arrays.toString(invocation.getArguments()), throwable});
                    response.setCode("500");
                    response.setMsg(CodeConstants.getName((String)"500"));
                }
                result.setAttachments(result.getAttachments());
                result.setValue((Object)response);
                result.setException(null);
            }
            String value = "";
            Object o = JSON.toJSON((Object)result.getValue());
            if (o != null) {
                value = o.toString();
            }
            log.info("[{}][{}|{}](T:{})return:{}", new Object[]{contextType, address, interfaceName, endTime - beginTime, value.length() > 512 ? value.substring(0, 512) + "......" : value});
            Result result3 = result;
            return result3;
        }
        catch (RpcException e) {
            log.error("[dubbo\u8fc7\u6ee4\u5668]\u8c03\u7528[{}|{}.{}({})]\u51fa\u9519: {}. Arguments[{}]", new Object[]{address, invoker.getInterface().getName(), invocation.getMethodName(), Arrays.toString(invocation.getParameterTypes()), e.getMessage(), Arrays.toString(invocation.getArguments()), e});
            throw e;
        }
        finally {
            if (rpcContext.isProviderSide()) {
                MDC.remove((String)CommonConstants.TRACE_ID_KEY);
                LocaleContextHolder.resetLocaleContext();
            }
        }
    }
}

