/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.strategy;

import com.icetech.rocketmq.annotation.CommonMessage;
import com.icetech.rocketmq.annotation.OrderMessage;
import com.icetech.rocketmq.annotation.RocketMessage;
import com.icetech.rocketmq.annotation.TransactionMessage;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.core.factory.execution.ProducerFactoryExecution;
import com.icetech.rocketmq.core.factory.execution.ThreadPoolExecutorExecution;
import com.icetech.rocketmq.core.utils.AnnotatedMethodsUtils;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.context.ApplicationContext;

public class RocketConsumerStrategy {
    private RocketConsumerStrategy() {
    }

    public static void putProducer(ThreadPoolExecutor threadPoolExecutor, Map<String, Object> producerConsumer, Object bean, RocketProperties rocketProperties, ApplicationContext applicationContext) {
        RocketMessage rocketMessage = bean.getClass().getAnnotation(RocketMessage.class);
        AnnotatedMethodsUtils.getMethodAndAnnotation(bean, CommonMessage.class).forEach((method, commonMessage) -> {
            ProducerFactoryExecution producerFactoryExecution = new ProducerFactoryExecution(producerConsumer, rocketMessage, commonMessage, rocketProperties, applicationContext);
            ThreadPoolExecutorExecution.statsThread(threadPoolExecutor, producerFactoryExecution);
        });
        AnnotatedMethodsUtils.getMethodAndAnnotation(bean, OrderMessage.class).forEach((method, orderMessage) -> {
            ProducerFactoryExecution producerFactoryExecution = new ProducerFactoryExecution(producerConsumer, rocketMessage, orderMessage, rocketProperties, applicationContext);
            ThreadPoolExecutorExecution.statsThread(threadPoolExecutor, producerFactoryExecution);
        });
        AnnotatedMethodsUtils.getMethodAndAnnotation(bean, TransactionMessage.class).forEach((method, transactionMessage) -> {
            ProducerFactoryExecution producerFactoryExecution = new ProducerFactoryExecution(producerConsumer, rocketMessage, transactionMessage, rocketProperties, applicationContext);
            ThreadPoolExecutorExecution.statsThread(threadPoolExecutor, producerFactoryExecution);
        });
    }
}

