/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.factory.execution;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.batch.BatchMessageListener;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.icetech.rocketmq.annotation.MessageListener;
import com.icetech.rocketmq.annotation.RocketListener;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.core.consumer.DefaultBatchMessageListener;
import com.icetech.rocketmq.core.consumer.DefaultMessageListener;
import com.icetech.rocketmq.core.consumer.DefaultMessageOrderListener;
import com.icetech.rocketmq.core.factory.ConsumerFactory;
import com.icetech.rocketmq.core.factory.ConsumerPropertiesFactory;
import com.icetech.rocketmq.core.factory.execution.MethodFactoryExecution;
import com.icetech.rocketmq.thread.AbstractConsumerThread;
import java.util.Properties;

public class ConsumerFactoryExecution
extends AbstractConsumerThread {
    public ConsumerFactoryExecution(RocketProperties rocketProperties, RocketListener rocketListener, MessageListener consumerListener, MethodFactoryExecution methodFactoryExecution) {
        super(rocketProperties, rocketListener, consumerListener, methodFactoryExecution);
    }

    @Override
    public void statsConsumer(RocketProperties rocketProperties, RocketListener rocketListener, MessageListener consumerListener, MethodFactoryExecution methodFactoryExecution) {
        Properties properties = ConsumerPropertiesFactory.createConsumerProperties(rocketProperties, rocketListener);
        if (consumerListener.orderConsumer()) {
            properties.put("suspendTimeMillis", rocketProperties.getSuspendTimeMilli());
            OrderConsumer orderConsumer = ConsumerFactory.createOrderConsumer(properties);
            orderConsumer.subscribe(consumerListener.topic(), consumerListener.tag(), (MessageOrderListener)new DefaultMessageOrderListener(methodFactoryExecution));
            orderConsumer.start();
            return;
        }
        if (consumerListener.batchConsumer()) {
            properties.put("ConsumeMessageBatchMaxSize", (Object)consumerListener.consumeMessageBatchMaxSize());
            properties.put("batchConsumeMaxAwaitDurationInSeconds", (Object)consumerListener.batchConsumeMaxAwaitDurationInSeconds());
            BatchConsumer batchConsumer = ConsumerFactory.createBatchConsumer(properties);
            batchConsumer.subscribe(consumerListener.topic(), consumerListener.tag(), (BatchMessageListener)new DefaultBatchMessageListener(methodFactoryExecution));
            batchConsumer.start();
        }
        Consumer consumer = ConsumerFactory.createConsumer(properties);
        consumer.subscribe(consumerListener.topic(), consumerListener.tag(), (com.aliyun.openservices.ons.api.MessageListener)new DefaultMessageListener(methodFactoryExecution));
        consumer.start();
    }
}

