/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.container;

import com.icetech.rocketmq.annotation.MessageListener;
import com.icetech.rocketmq.annotation.RocketListener;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.core.factory.ThreadPoolFactory;
import com.icetech.rocketmq.core.factory.execution.ConsumerFactoryExecution;
import com.icetech.rocketmq.core.factory.execution.MethodFactoryExecution;
import com.icetech.rocketmq.core.factory.execution.ThreadPoolExecutorExecution;
import com.icetech.rocketmq.core.serializer.RocketSerializer;
import com.icetech.rocketmq.core.utils.AnnotatedMethodsUtils;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RocketConsumerContainer
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private RocketProperties rocketProperties;
    private RocketSerializer mqSerializer;

    public RocketConsumerContainer(RocketProperties rocketProperties, RocketSerializer rocketSerializer) {
        this.rocketProperties = rocketProperties;
        this.mqSerializer = rocketSerializer;
    }

    @PostConstruct
    public void initialize() {
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.createConsumeThreadPoolExecutor(this.rocketProperties);
        this.applicationContext.getBeansWithAnnotation(RocketListener.class).forEach((beanName, bean) -> {
            RocketListener rocketListener = bean.getClass().getAnnotation(RocketListener.class);
            AnnotatedMethodsUtils.getMethodAndAnnotation(bean, MessageListener.class).forEach((method, consumerListener) -> {
                ConsumerFactoryExecution consumerFactoryExecution = new ConsumerFactoryExecution(this.rocketProperties, rocketListener, (MessageListener)consumerListener, new MethodFactoryExecution(bean, (Method)method, this.mqSerializer));
                ThreadPoolExecutorExecution.statsThread(threadPoolExecutor, consumerFactoryExecution);
            });
        });
        threadPoolExecutor.shutdown();
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

