/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.autoconfigure;

import com.google.common.collect.Maps;
import com.icetech.rocketmq.annotation.EnableRocketMQ;
import com.icetech.rocketmq.aspect.RocketAspect;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.container.RocketConsumerContainer;
import com.icetech.rocketmq.container.RocketProducerContainer;
import com.icetech.rocketmq.core.serializer.ProtoBufSerializer;
import com.icetech.rocketmq.core.serializer.RocketSerializer;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RocketProperties.class})
@ConditionalOnBean(annotation={EnableRocketMQ.class})
public class RocketAutoConfiguration {
    @Resource
    private RocketProperties rocketProperties;
    @Resource
    private Map<String, Object> consumerContainer;
    @Resource
    private RocketSerializer rocketSerializer;

    @Bean
    @ConditionalOnMissingBean(value={RocketConsumerContainer.class})
    public RocketConsumerContainer rocketConsumerContainer() {
        return new RocketConsumerContainer(this.rocketProperties, this.rocketSerializer);
    }

    @Bean
    @ConditionalOnMissingBean(value={RocketSerializer.class})
    public RocketSerializer rocketSerializer() {
        return new ProtoBufSerializer();
    }

    @Bean
    @ConditionalOnMissingBean(value={Map.class})
    public Map<String, Object> consumerContainer() {
        return Maps.newConcurrentMap();
    }

    @Bean
    @ConditionalOnMissingBean(value={RocketProducerContainer.class})
    public RocketProducerContainer rocketProducerContainer() {
        return new RocketProducerContainer(this.consumerContainer, this.rocketProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={RocketAspect.class})
    public RocketAspect rockerAspect() {
        return new RocketAspect(this.consumerContainer, this.rocketProperties);
    }
}

