/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.factory;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolFactory {
    private ThreadPoolFactory() {
    }

    public static ThreadPoolExecutor createConsumeThreadPoolExecutor(RocketProperties rocketProperties) {
        Integer threadNums = rocketProperties.getCreateConsumeThreadNums();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("InitializeConsumerListener").build();
        return new ThreadPoolExecutor(threadNums, threadNums, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public static ThreadPoolExecutor createProducerThreadPoolExecutor(RocketProperties rocketProperties) {
        Integer threadNums = rocketProperties.getCreateProducerThreadNums();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("InitializeProducer").build();
        return new ThreadPoolExecutor(threadNums, threadNums, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public static ThreadPoolExecutor createSendMessageThreadPoolExecutor(RocketProperties rocketProperties) {
        Integer threadNums = rocketProperties.getSendMessageThreadNums();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("SendMessage").build();
        return new ThreadPoolExecutor(threadNums, threadNums, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public static ThreadPoolExecutor createCallbackThreadPoolExecutor(RocketProperties rocketProperties) {
        Integer threadNums = rocketProperties.getCallbackThreadNums();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("callback").build();
        return new ThreadPoolExecutor(threadNums, threadNums, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }
}

