/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.factory;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.icetech.rocketmq.annotation.CommonMessage;
import com.icetech.rocketmq.annotation.OrderMessage;
import com.icetech.rocketmq.annotation.TransactionMessage;
import com.icetech.rocketmq.core.factory.MessageFactory;
import com.icetech.rocketmq.core.strategy.SendMessageStrategy;
import com.icetech.rocketmq.core.utils.ApplicationContextUtils;
import org.springframework.context.ApplicationContext;

public class SendMessageFactory {
    private SendMessageFactory() {
    }

    public static void sendMessage(Long startDeliverTime, Producer producer, CommonMessage commonMessage, byte[] bytes, ApplicationContext applicationContext) {
        Message message = MessageFactory.createMessage(commonMessage, bytes);
        if (null != startDeliverTime) {
            message.setStartDeliverTime(startDeliverTime.longValue());
        }
        SendMessageStrategy.send(commonMessage, producer, message, applicationContext);
    }

    public static void sendMessage(OrderProducer orderProducer, OrderMessage orderMessage, byte[] bytes) {
        Message message = MessageFactory.createMessage(orderMessage, bytes);
        orderProducer.send(message, orderMessage.shardingKey());
    }

    public static void sendMessage(TransactionProducer transactionProducer, TransactionMessage transactionMessage, byte[] bytes, ApplicationContext applicationContext) {
        Message message = MessageFactory.createMessage(transactionMessage, bytes);
        transactionProducer.send(message, ApplicationContextUtils.getLocalTransactionExecuter(applicationContext, transactionMessage.executer()), null);
    }
}

